/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionParam;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRpcDtoParam;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.domain.convert.invwh.InvWhAreaConvert;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhAreaDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhAreaDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaSettingDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaRpcDTO;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhAreaRepoProc;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhRepoProc;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvWhAreaServiceImpl
implements InvWhAreaService {
    private final InvWhAreaRepoProc invWhAreaRepoProc;
    private final InvWhRepoProc invWhRepoProc;
    private final InvWhDomainService invWhDomainService;
    private final InvWhAreaDomainService invWhAreaDomainService;
    private final InvWhAreaSettingDomainService invWhAreaSettingDomainService;
    private final SystemService systemService;
    private final OrgOutService orgOutService;

    @Override
    @SysCodeProc
    public PagingVO<InvWhAreaRespVO> search(InvWhAreaParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.invWhAreaRepoProc.select(null).where(this.invWhAreaRepoProc.searchWhere(param));
        this.invWhAreaRepoProc.openOrderAndLimit(jpaQuery, param, QInvWhAreaDO.invWhAreaDO);
        long dataCount = jpaQuery.fetchCount();
        List lists = jpaQuery.fetch();
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(dataCount);
        return paging;
    }

    @Override
    @SysCodeProc
    public PagingVO<InvWhRespVO> searchWh(InvWhParamVO param) {
        JPAQuery invWhs = (JPAQuery)this.invWhRepoProc.select(null).where(this.invWhRepoProc.searchWhere(param));
        long dataCount = invWhs.fetchCount();
        List lists = invWhs.fetch();
        this.invWhRepoProc.openOrderAndLimit(invWhs, param, QInvWhDO.invWhDO);
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(dataCount);
        return paging;
    }

    @Override
    @SysCodeProc
    public List<InvWhRespVO> searchWhByParam(InvWhParamVO param) {
        List<InvWhRespVO> invWhRespVOS = this.invWhDomainService.searchWhByParam(param);
        return invWhRespVOS;
    }

    @Override
    @SysCodeProc
    public Optional<InvWhAreaRespVO> findIdOne(Long id) {
        JPAQuery<InvWhAreaRespVO> jpaQuery = this.invWhAreaRepoProc.select(null);
        QInvWhAreaDO jpaQDo = QInvWhAreaDO.invWhAreaDO;
        jpaQuery.where((Predicate)jpaQDo.id.eq((Object)id));
        InvWhAreaRespVO vo = (InvWhAreaRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @Override
    public List<InvWhAreaRespVO> findAllByWhId(List<Long> whIds) {
        QInvWhAreaDO jpaQDo = QInvWhAreaDO.invWhAreaDO;
        JPAQuery where = (JPAQuery)this.invWhAreaRepoProc.select(null).where((Predicate)jpaQDo.whId.in(whIds));
        List lists = where.fetch();
        return lists;
    }

    @Override
    public List<InvWhAreaRespVO> findWhAreasByParam(InvWhAreaParamVO paramVO) {
        List<InvWhAreaRespVO> invWhAreaRespVOList = this.invWhAreaDomainService.findWhAreasByParam(paramVO);
        return invWhAreaRespVOList;
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<InvWhAreaSaveVO> list) {
        return this.invWhAreaDomainService.saveInvWhAreas(list.stream().map(InvWhAreaConvert.INSTANCE::voToDO).collect(Collectors.toList())).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void update(InvWhAreaSaveVO item) {
        Optional<InvWhAreaDO> optional = this.invWhAreaDomainService.findOneById(item.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + item.getId());
        }
        this.invWhAreaDomainService.saveInvWhArea(InvWhAreaConvert.INSTANCE.voToDO(item));
    }

    @Override
    @SysCodeProc
    public List<InvWhAreaRpcDTO> findWhAreaRpcDTOByWhIds(List<Long> whIds) {
        InvWhAreaRpcDtoParam paramRpcDTO = new InvWhAreaRpcDtoParam();
        paramRpcDTO.setWhIds(whIds);
        List<InvWhAreaRpcDTO> whAreaRpcDTOS = this.invWhAreaRepoProc.selectByParam(paramRpcDTO);
        Map<String, String> pTypeMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_EMP.getModel(), UdcEnum.INV_PARTNER_TYPE_EMP.getCode());
        for (InvWhAreaRpcDTO whAreaRpcDTO : whAreaRpcDTOS) {
            if (StringUtils.isEmpty((Object)whAreaRpcDTO.getPType()) || StringUtils.isEmpty((Object)whAreaRpcDTO.getPCode())) continue;
            InvParentParamVO paramVO = new InvParentParamVO();
            paramVO.setType(whAreaRpcDTO.getPType());
            paramVO.setCode(whAreaRpcDTO.getPCode());
            List<OrgRespVO> vos = this.orgOutService.findcodeAndName(paramVO);
            if (!CollectionUtils.isEmpty(vos)) {
                vos.stream().filter(m -> m.getCode().equals(whAreaRpcDTO.getPCode())).findFirst().ifPresent(n -> whAreaRpcDTO.setPName(n.getName()));
            }
            if (MapUtils.isEmpty(pTypeMap)) continue;
            whAreaRpcDTO.setPTypeName(pTypeMap.get(whAreaRpcDTO.getPType()));
        }
        return whAreaRpcDTOS;
    }

    @Override
    public List<SelectOptionVO> listDeter2(SelectOptionParam param) {
        List<SelectOptionVO> selectOptionVOS = this.invWhAreaRepoProc.listDeter2(param);
        return this.invWhAreaRepoProc.listDeter2(param);
    }

    @Override
    public List<InvWhAreaRespVO> findBydeter2AndDeter2Type(String deter2, String deter2Type) {
        return this.invWhAreaRepoProc.findDeter2AndDeter2Type(deter2, deter2Type);
    }

    public InvWhAreaServiceImpl(InvWhAreaRepoProc invWhAreaRepoProc, InvWhRepoProc invWhRepoProc, InvWhDomainService invWhDomainService, InvWhAreaDomainService invWhAreaDomainService, InvWhAreaSettingDomainService invWhAreaSettingDomainService, SystemService systemService, OrgOutService orgOutService) {
        this.invWhAreaRepoProc = invWhAreaRepoProc;
        this.invWhRepoProc = invWhRepoProc;
        this.invWhDomainService = invWhDomainService;
        this.invWhAreaDomainService = invWhAreaDomainService;
        this.invWhAreaSettingDomainService = invWhAreaSettingDomainService;
        this.systemService = systemService;
        this.orgOutService = orgOutService;
    }
}

