/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.domain.service.impl;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigWhPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigDtlQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigQueryParam;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.domain.convert.despatch.InvDespatchConfigConvert;
import com.elitesland.yst.production.inv.domain.entity.despatch.InvDespatchConfigDO;
import com.elitesland.yst.production.inv.domain.service.InvDespatchConfigDomainService;
import com.elitesland.yst.production.inv.dto.invDes.param.InvDespatchRpcParam;
import com.elitesland.yst.production.inv.dto.invDes.resp.InvDespatchRpcDTO;
import com.elitesland.yst.production.inv.infr.dto.InvDespatchConfigDTO;
import com.elitesland.yst.production.inv.infr.repo.despatch.InvDespatchConfigProc;
import com.elitesland.yst.production.inv.infr.repo.despatch.InvDespatchConfigRepo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InvDespatchConfigDomainServiceImpl
implements InvDespatchConfigDomainService {
    private static final Logger log = LoggerFactory.getLogger(InvDespatchConfigDomainServiceImpl.class);
    private final InvDespatchConfigProc invDespatchConfigProc;
    private final InvDespatchConfigRepo invDespatchConfigRepo;
    private final OrgOutService orgOutService;
    private final JdbcTemplate jdbcTemplate;

    @Override
    public PagingVO<InvDespatchConfigPageVO> searchPage(InvDespatchConfigQueryParam param) {
        return this.invDespatchConfigProc.searchPage(param);
    }

    @Override
    public List<InvDespatchConfigPageVO> query(InvDespatchConfigQueryParam queryParam) {
        return this.invDespatchConfigProc.query(queryParam);
    }

    @Override
    public InvDespatchConfigDTO findIdOne(Long id) {
        InvDespatchConfigDTO invDespatchConfigDTO = null;
        Optional optional = this.invDespatchConfigRepo.findById(id);
        if (optional.isPresent()) {
            invDespatchConfigDTO = InvDespatchConfigConvert.INSTANCE.doToDto((InvDespatchConfigDO)optional.get());
        }
        return invDespatchConfigDTO;
    }

    @Override
    @Transactional
    public Long saveOrUpdate(InvDespatchConfigDTO despatchConfigDTO) {
        InvDespatchConfigDO despatchConfigDO = InvDespatchConfigConvert.INSTANCE.dtoToDo(despatchConfigDTO);
        return ((InvDespatchConfigDO)this.invDespatchConfigRepo.save(despatchConfigDO)).getId();
    }

    @Override
    public PagingVO<InvDespatchConfigWhPageVO> searchDespatchWhPage(InvDespatchConfigDtlQueryParam param) {
        return this.invDespatchConfigProc.searchDespatchWhPage(param);
    }

    @Override
    public PagingVO<InvDespatchConfigWhPageVO> newSearchDespatchWhPage(InvDespatchConfigDtlQueryParam param) {
        return this.invDespatchConfigProc.newSearchDespatchWhPage(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean enableDespatchConfig(List<Long> ids, String isEnable) {
        try {
            this.invDespatchConfigProc.enableDespatchConfig(ids, isEnable);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5931\u8d25\uff1a" + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public List<InvDespatchConfigRespVO> getDeter2Count(List<String> desCodes) {
        List<Map<String, Object>> mapList = this.invDespatchConfigRepo.getdeter2Count(desCodes);
        if (!CollectionUtils.isEmpty(mapList = mapList.stream().filter(i -> !i.isEmpty() && i.size() > 0).collect(Collectors.toList()))) {
            List invDespatchConfigRespVOS = JSON.parseArray((String)JSON.toJSONString(mapList), InvDespatchConfigRespVO.class);
            return invDespatchConfigRespVOS;
        }
        return null;
    }

    @Override
    public List<InvDespatchRpcDTO> findDespatchRpcByParam(InvDespatchRpcParam param) {
        return this.invDespatchConfigProc.findDespatchRpcByParam(param);
    }

    @Override
    public List<InvDespatchRpcDTO> findByDesName(String desName) {
        InvDespatchRpcParam param = new InvDespatchRpcParam();
        param.setDesName(desName);
        return this.invDespatchConfigProc.findDespatchRpcByParam(param);
    }

    @Override
    public List<InvDespatchRpcDTO> findByDesCode(String desCode) {
        InvDespatchRpcParam param = new InvDespatchRpcParam();
        param.setDesCode(desCode);
        return this.invDespatchConfigProc.findDespatchRpcByParam(param);
    }

    @Override
    public List<InvDespatchConfigRespVO> findByIdBatch(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<InvDespatchConfigRespVO>();
        }
        return this.invDespatchConfigProc.findDespatchByIdBatch(ids);
    }

    @Override
    public List<InvDespatchRpcDTO> findByDesCodeBatch(List<String> desCodes) {
        if (CollectionUtils.isEmpty(desCodes)) {
            return new ArrayList<InvDespatchRpcDTO>();
        }
        InvDespatchRpcParam param = new InvDespatchRpcParam();
        param.setDesCodes(desCodes);
        return this.invDespatchConfigProc.findDespatchRpcByParam(param);
    }

    @Override
    public List<InvDespatchRpcDTO> findByDesCodeBatch(List<String> desCodes, Long tenantId) {
        if (CollectionUtils.isEmpty(desCodes)) {
            return new ArrayList<InvDespatchRpcDTO>();
        }
        StringBuffer sb = new StringBuffer("SELECT                id,               des_code as desCode,               des_name as desName,               is_enable as isEnable,               deter1 as deter1,               deter3 as deter3,               deter4 as deter4,               deter5 as deter5,               deter6 as deter6,               trade_company_flag as tradeCompanyFlag                 FROM  inv_despatch_config               WHERE  (delete_flag = 0 or delete_flag  is null)                   AND tenant_id = '" + tenantId + "' ");
        sb.append(" and des_code in ('");
        sb.append(String.join((CharSequence)"','", desCodes));
        sb.append("')");
        return this.jdbcTemplate.query(sb.toString(), (RowMapper)new BeanPropertyRowMapper(InvDespatchRpcDTO.class));
    }

    public InvDespatchConfigDomainServiceImpl(InvDespatchConfigProc invDespatchConfigProc, InvDespatchConfigRepo invDespatchConfigRepo, OrgOutService orgOutService, JdbcTemplate jdbcTemplate) {
        this.invDespatchConfigProc = invDespatchConfigProc;
        this.invDespatchConfigRepo = invDespatchConfigRepo;
        this.orgOutService = orgOutService;
        this.jdbcTemplate = jdbcTemplate;
    }
}

