/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCombineParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvStkDParam;
import com.elitesland.yst.production.inv.domain.convert.InvLotConvert;
import com.elitesland.yst.production.inv.domain.entity.lot.InvLot;
import com.elitesland.yst.production.inv.domain.entity.lot.InvLotDO;
import com.elitesland.yst.production.inv.domain.entity.lot.QInvLotDO;
import com.elitesland.yst.production.inv.domain.service.InvLotDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvLotDTO;
import com.elitesland.yst.production.inv.infr.dto.InvLotStkDTO;
import com.elitesland.yst.production.inv.infr.repo.lot.InvLotRepo;
import com.elitesland.yst.production.inv.infr.repo.lot.InvLotRepoProc;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvLotDomainServiceImpl
implements InvLotDomainService {
    private final InvLotRepo invLotRepo;
    private final InvLotRepoProc invLotRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> createBatch(List<InvLot> list) {
        return this.invLotRepo.saveAll(list.stream().map(InvLotConvert.INSTANCE::enToDo).collect(Collectors.toList())).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createOne(InvLot invLot) {
        return ((InvLotDO)this.invLotRepo.save(InvLotConvert.INSTANCE.enToDo(invLot))).getId();
    }

    @Override
    @SysCodeProc
    public List<InvLotDTO> findByParam(InvLotParam queryParam) {
        List invLotDTOList = ((JPAQuery)this.invLotRepoProc.select(null).where(this.invLotRepoProc.where(queryParam))).fetch();
        if (CollectionUtils.isEmpty((Collection)invLotDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return invLotDTOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<InvLotDTO> invLotSearch(InvLotParam param) {
        PagingVO<InvLotDTO> pagingVo = this.invLotRepoProc.useSelect(param);
        return pagingVo;
    }

    @Override
    @SysCodeProc
    public PagingVO<InvLotStkDTO> useSelectD(InvStkDParam param) {
        PagingVO<InvLotStkDTO> pagingVo = this.invLotRepoProc.useSelectD(param);
        return pagingVo;
    }

    @Override
    @SysCodeProc
    public PagingVO<InvLotDTO> findCombine(InvLotCombineParam param) {
        Page ret = this.invLotRepo.findAll(this.invLotRepoProc.searchWhere(param), (Pageable)param.getPageRequest());
        if (CollectionUtils.isEmpty((Collection)ret.getContent())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List vos = ret.getContent();
        List invLotDTOList = vos.stream().map(InvLotConvert.INSTANCE::doToDto).collect(Collectors.toList());
        return PagingVO.builder().total(ret.getTotalElements()).records(invLotDTOList).build();
    }

    @Override
    @SysCodeProc
    public Optional<InvLotDTO> findById(Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return Optional.empty();
        }
        return this.invLotRepo.findById(id).map(InvLotConvert.INSTANCE::doToDto);
    }

    @Override
    @SysCodeProc
    public List<InvLotDTO> findIdBatch(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.EMPTY_LIST;
        }
        QInvLotDO jpaQDo = QInvLotDO.invLotDO;
        JPAQuery jpaQuery = (JPAQuery)this.invLotRepoProc.select(null).where((Predicate)jpaQDo.id.in(ids));
        return jpaQuery.fetch();
    }

    @Override
    @SysCodeProc
    public List<InvLotDTO> findAllByItemIdAndLotNo(Long itmId, String lotNo) {
        List<InvLotDO> invLotDOList = this.invLotRepo.findAllByItemIdAndLotNo(itmId, lotNo);
        if (CollectionUtils.isEmpty(invLotDOList)) {
            return Collections.EMPTY_LIST;
        }
        List<InvLotDTO> invLotDTOList = invLotDOList.stream().map(InvLotConvert.INSTANCE::doToDto).collect(Collectors.toList());
        return invLotDTOList;
    }

    @Override
    @SysCodeProc
    public List<InvLotDTO> findAllByItemIdAndLotNoAndVariId(InvLotParam param) {
        List invLotDTOList = this.invLotRepoProc.findAllByItemIdAndLotNoAndVariId(param).fetch();
        if (CollectionUtils.isEmpty((Collection)invLotDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return invLotDTOList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagById(Integer deleteFlag, Long id) {
        this.invLotRepoProc.updateDeleteFlagById(deleteFlag, id).execute();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteById(Long id) {
        this.invLotRepo.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addSinQty(String lotNo, Long itemId, Double sinQty, String sinStatus, String sinNo) {
        this.invLotRepo.addSinQty(lotNo, itemId, sinQty, sinStatus, sinNo);
    }

    @Override
    public List<InvLotDO> findByQueryParam(List<String> queryParam) {
        return this.invLotRepo.findByConcatKey(queryParam);
    }

    public InvLotDomainServiceImpl(InvLotRepo invLotRepo, InvLotRepoProc invLotRepoProc) {
        this.invLotRepo = invLotRepo;
        this.invLotRepoProc = invLotRepoProc;
    }
}

