/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.utils;

import com.elitesland.yst.production.inv.utils.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class TreeUtils {
    private TreeUtils() {
    }

    public static <T extends TreeNode<T>> List<T> buildTree(Long id, boolean sort, List<T> treeNodes) {
        Map<Long, TreeNode> nodeIdMap = treeNodes.stream().collect(Collectors.toMap(TreeNode::getId, t -> t));
        Map<Long, List<T>> nodePidMap = treeNodes.stream().collect(Collectors.groupingBy(t -> t.getPid() == null ? 0L : t.getPid()));
        return TreeUtils.buildTree(id, sort, nodeIdMap, nodePidMap);
    }

    public static <T extends TreeNode<T>> List<T> buildTree(Long id, boolean sort, Map<Long, T> nodeIdMap, Map<Long, List<T>> nodePidMap) {
        id = id == null ? 0L : id;
        TreeNode topTreeNode = null;
        List pTree = null;
        if (nodeIdMap.containsKey(id) && (topTreeNode = (TreeNode)nodeIdMap.get(id)) != null) {
            pTree = Collections.singletonList(topTreeNode);
        }
        if (pTree == null && nodePidMap.containsKey(id)) {
            pTree = nodePidMap.get(id);
        }
        if (pTree == null || pTree.size() == 0) {
            return null;
        }
        List<TreeNode> treeList = TreeUtils.build(pTree, nodePidMap);
        if (sort) {
            TreeUtils.sort(treeList);
        }
        return treeList;
    }

    private static <T extends TreeNode<T>> List<T> build(List<T> treeNodes, Map<Long, List<T>> pTreeNodeMap) {
        for (TreeNode treeNode : treeNodes) {
            if (pTreeNodeMap.containsKey(treeNode.getId())) {
                List<T> subTrees = TreeUtils.build(pTreeNodeMap.get(treeNode.getId()), pTreeNodeMap);
                treeNode.setIsLeaf(false);
                treeNode.setTreeNodes(subTrees);
                continue;
            }
            treeNode.setIsLeaf(true);
        }
        return treeNodes;
    }

    private static <T extends TreeNode<T>> void sort(List<T> treeNodes) {
        if (treeNodes != null && !treeNodes.isEmpty()) {
            Collections.sort(treeNodes);
            for (TreeNode treeNode : treeNodes) {
                if (treeNode.getTreeNodes() == null || treeNode.getTreeNodes().isEmpty()) continue;
                TreeUtils.sort(treeNode.getTreeNodes());
            }
        }
    }

    public <T extends TreeNode<T>> List<T> buildTree(List<T> treeNodes) {
        Collections.sort(treeNodes);
        Map<String, TreeNode> idMap = treeNodes.stream().collect(Collectors.toMap(TreeNode::getCode, t -> t, (t1, t2) -> t1));
        ArrayList tree = new ArrayList();
        treeNodes.forEach(node -> {
            String[] pathCodes;
            String path = node.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((pathCodes = path.split("/")).length > 1) {
                boolean isRoot = true;
                for (int i = pathCodes.length - 2; i >= 0; --i) {
                    String code = pathCodes[i];
                    if (!idMap.containsKey(code)) continue;
                    isRoot = false;
                    TreeNode pNode = (TreeNode)idMap.get(code);
                    if (pNode.getTreeNodes() == null) {
                        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
                        list.add((TreeNode)node);
                        pNode.setTreeNodes(list);
                        break;
                    }
                    pNode.getTreeNodes().add(node);
                    break;
                }
                if (isRoot) {
                    tree.add(node);
                }
            } else {
                tree.add(node);
            }
        });
        return tree;
    }

    public static <T extends TreeNode<T>> List<T> treeToList(List<T> treeNodes, List<T> result, Long pid) {
        int sortNo = 1;
        for (TreeNode treeNode : treeNodes) {
            List childNodes = treeNode.getTreeNodes();
            treeNode.setPid(pid);
            treeNode.setSortNo(sortNo);
            ++sortNo;
            if (CollectionUtils.isNotEmpty(childNodes)) {
                Long id = treeNode.getId();
                TreeUtils.treeToList(childNodes, result, id);
            }
            treeNode.setTreeNodes(null);
            result.add(treeNode);
        }
        return result;
    }
}

