package com.elitesland.yst.production.inv.application.facade.export.invstk;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jeesie.jiang
 * @date 2020-10-29 13:59
 * Desc:
 */

@Data
@ExcelIgnoreUnannotated
@HeadRowHeight(35)
public class InvStkDExcelRespVO implements Serializable {
    private static final long serialVersionUID = -7689137633475152019L;

    @ExcelProperty(value = "仓库编码")
    private String whCode;

    @ExcelProperty(value = "仓库名称")
    private String whName;

    @ExcelProperty(value = "仓库类型")
    private String whTypeName;

    @ExcelProperty(value = "商品编码")
    private String itemCode;

    @ExcelProperty(value = "商品名称")
    private String itemName;

    @ExcelProperty(value = "商品规格")
    private String packageSpec;

    @ExcelProperty(value = "商品条码")
    private String barCode;

    @ExcelProperty(value = "库存数量")
    private BigDecimal ohQty;

    @ExcelProperty(value = "可用数量")
    private BigDecimal avalQty;

    @ExcelProperty("付款订单锁定数量")
    private BigDecimal rsvQty;

    @ExcelProperty("调拨在途量")
    private BigDecimal lockQty;

    @ExcelProperty(value = "单位")
    private String uomName;

    @ExcelProperty(value = "功能区")
    private String deter2Name;

    @ExcelProperty("保质期(天)")
    private Integer expireDays;

    @ExcelProperty("库存合作伙伴编码")
    private String pcode;

    @ExcelProperty("库存合作伙伴名称")
    private String pname;

    @ExcelProperty("库存合作伙伴类型")
    private String ptype;

    @ExcelProperty(value = "品牌名称")
    private String brandName;

    @ExcelProperty(value = "供应商编码")
    private String suppCode;

    @ExcelProperty(value = "供应商名称")
    private String suppName;

    @ExcelProperty(value = "公司编码")
    private String ouCode;

    @ExcelProperty(value = "公司名称")
    private String ouName;

    @ExcelProperty(value = "一级品类")
    private String c1CodeName;

    @ExcelProperty(value = "二级品类")
    private String c2CodeName;

    @ExcelProperty(value ="三级品类")
    private String c3CodeName;



}
