package com.elitesland.yst.production.inv.application.facade.vo.base;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 库存公共参数
 * </p >
 *
 * @author ssy
 * @date 2020/8/12
 */
@Data
public class InvBaseModel implements Serializable{

    private static final long serialVersionUID = -3284318810676315265L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品ID")
    @NotNull
    private Long itemId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("异构ID")
    private Long variId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库ID")
    @NotNull
    private Long whId;

    @ApiModelProperty("温层[UDC]INV:TEMP_TYPE")
    private String deter1;

    @ApiModelProperty("功能库区[UDC]INV:FUNC_TYPE")
    @NotEmpty
    private String deter2;

    @ApiModelProperty("客户号")
    private String deter3;

    @ApiModelProperty("库存合作伙伴类型")
    private String pType;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("序列号")
    private String snNo;

    @ApiModelProperty("deter4")
    private String deter4;

    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("deter5")
    private String deter5;

    @ApiModelProperty("limit2")
    private String limit2;



}
