package com.elitesland.yst.production.inv.application.facade.vo.carr;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author feng
 * @program: yst-inv
 * @description: 承运商配送单明细
 * @date 2021-09-19 11:22:40
 */
@Data
@ApiModel(value = "inv_carr_d", description = "承运商配送单明细")
public class InvCarrDRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 5067596315895791372L;
    /**
     * 主表ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主表ID")
    private Long masId;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    /**
     * 品项ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品ID")
    private Long itemId;
    private String itemCode;
    private String itemName;
    private String itemSpec;

    /**
     * 发货数量
     */
    @ApiModelProperty("发货数量")
    private BigDecimal qty;


    @ApiModelProperty("发货单位")
    @SysCode(sys = "COM", mod = "UOM")
    private String uom;
    private String uomName;

    /**
     * 关联单据ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLineno;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("采购单明细ID")
    private Long poDId;


    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;



}
