package com.elitesland.yst.production.inv.application.facade.vo.carr;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author feng
 * @program: yst-inv
 * @description: 承运商配送单
 * @date 2021-09-19 13:13:27
 */
@Data
@ApiModel(description = "承运商配送单" ,value = "inv_carr")
public class InvCarrSaveVO implements Serializable {


    private static final long serialVersionUID = 58226340222235074L;

    @ApiModelProperty("配送单主表id")
    private Long id;
    @ApiModelProperty("配送单单号")
    private String docNo;
    @ApiModelProperty("承运商ID")
    private Long carrierSuppId;
    @ApiModelProperty("承运商编码")
    private String carrierSuppCode;
    @ApiModelProperty("供应商ID(发货单位)")
    private Long suppId;
    @ApiModelProperty("发货地址")
    private String shipmentDetailAddr;
    @ApiModelProperty("发货联系人")
    private String shipmentContactName;
    @ApiModelProperty("发货联系电话")
    private String shipmentContactTel;
    @ApiModelProperty("公司ID(收货单位)")
    private Long ouId;
    @ApiModelProperty("收货地址")
    private String recvAddr;
    @ApiModelProperty("收货人名称")
    private String recvEmpName;
    @ApiModelProperty("收货联系电话")
    private String tel;
    @ApiModelProperty("关联单据ID(发货单id)")
    private Long relateDocId;
    @ApiModelProperty("关联单据编号(发货单号)")
    private String relateDocNo;
    @ApiModelProperty("采购单id")
    private Long poId;
    @ApiModelProperty("发货日期")
    private LocalDateTime shipmentDate;
    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("快递公司编号")
    private String logisticsOuCode;
    @ApiModelProperty("快递公司名称")
    private String logisticsOuName;
    @ApiModelProperty("物流单号")
    private String logisticsDocNo;
    @ApiModelProperty("车号")
    private String carNumber;
    @ApiModelProperty("司机")
    private String driver;
    @ApiModelProperty("司机电话")
    private String driverPhone;
    @ApiModelProperty("包装数量")
    private String packingQty;
    @ApiModelProperty("总重量")
    private String totalWeight;
    @ApiModelProperty("物流备注")
    private String logisticsRemark;
    @ApiModelProperty("文件服务器编码")
    private String fileCode;
    @ApiModelProperty("配送日期")
    private LocalDateTime deliveryDate;
    @ApiModelProperty("承运商联系人")
    private String carrierContactName;
    @ApiModelProperty("承运商联系电话")
    private String carrierContactTel;
    @ApiModelProperty("配送单明细")
    private List<InvCarrDSaveVO> invCarrDSaveVOS;
    @ApiModelProperty("附件集合")
    private List<InvCarrFileSaveVO> invCarrFileSaveVOS;
}
