package com.elitesland.yst.production.inv.application.facade.vo.ck;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lvqf
 * @Date 2021/2/10
 * @Description
 */
@Data
@ApiModel(value = "inv_ck_d", description = "库存盘点明细")
public class InvCkDParamVO {

    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("行号")
    private Float lineNo;

    @ApiModelProperty("行状态")
    private String lineStatus;

    @ApiModelProperty("行类型 [UDC]COM:IO")
    @SysCode(sys = "COM", mod = "IO")
    private String lineType;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    private String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    String deter2;

    @ApiModelProperty("客户标识")
    String deter3;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long itemId;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long variId;

    @ApiModelProperty("批次")
    String lotNo;

    @ApiModelProperty("序列号")
    String snNo;

    @ApiModelProperty("账面数")
    Float accQty;

    @ApiModelProperty("实盘数")
    Float factQty;

    @ApiModelProperty("差异数")
    Float diffQty;

    @ApiModelProperty("单位")
    String uom;
}
