package com.elitesland.yst.production.inv.application.facade.vo.ck;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author lvqf
 * @Date 2021/2/10
 * @Description
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "inv_ck", description = "库存盘点")
public class InvCkParamVO extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = 413489393295649182L;
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("主表IDs")
    private List<Long> masIds;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("明细功能区list")
    private List<String> deter2List;

    @ApiModelProperty("创建人")
    private Long createUserId;

    @ApiModelProperty("创建时间起")
    private LocalDateTime createTimeStart;

    @ApiModelProperty("创建时间止")
    private LocalDateTime createTimeEnd;


    @ApiModelProperty("盘点单号")
    private String docNo;

    @ApiModelProperty("盘点类型 [UDC]INV:CK_TYPE")
    private String docType;

    @ApiModelProperty("盘点单状态 [UDC]INV:CK_STATUS")
    private String docStatus;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private List<Long> ouIds;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("盘点方式")
    private String docMethod;

    @ApiModelProperty("转调整单状态")
    private Integer isAjStatus;

    @ApiModelProperty("功能区关键字查询")
    private String deter2KeyWord;


}
