package com.elitesland.yst.production.inv.application.facade.vo.ck;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author lvqf
 * @Date 2021/2/10
 * @Description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InvCkRespVO extends BaseModelVO implements Serializable {


    private static final long serialVersionUID = -9191457941321935668L;

    @ApiModelProperty("账号唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("盘点单号")
    private String docNo;

    @ApiModelProperty("盘点类型 [UDC]INV:CK_TYPE")
    private String docType;
    @ApiModelProperty("盘点类型名称 [UDC]INV:CK_TYPE")
    private String docTypeName;

    @ApiModelProperty("盘点单状态 [UDC]INV:CK_STATUS")
    private String docStatus;
    @ApiModelProperty("盘点单状态名称")
    private String docStatusName;

    @ApiModelProperty("盘点方式")
    private String docMethod;

    @ApiModelProperty("盘点方式名称")
    private String docMethodName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private  Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @ApiModelProperty("转调整单状态")
    private Integer isAjStatus;

    @ApiModelProperty("单据类别")
    private String docCls;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;
    public String getProcInstStatusName() {
        return procInstStatus != null ? procInstStatus.getDesc() : null;
    }

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;
}
