package com.elitesland.yst.production.inv.application.facade.vo.despatch;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 01月 05日 2:38 下午
 * @version: 1.0
 */
@Data
@ApiModel(value = "invDespatchConfigWhPageVO", description = "货运地绑定仓库对象")
public class InvDespatchConfigWhPageVO extends BaseModelVO implements Serializable {

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编号")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("功能区名")
    private String deter2Name;

    @ApiModelProperty("公司Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("仓库类型")
    @SysCode(sys = "yst-inv", mod = "WH_TYPE")
    private String whType;

    @ApiModelProperty("仓库类型名")
    private String whTypeName;

    @ApiModelProperty("库区ID")
    private Long areaId;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("功能区类型名")
    private String deter2TypeName;







}
