package com.elitesland.yst.production.inv.application.facade.vo.invTrn;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jeesie.jiang
 * @date 2022-03-17 11:27
 * Desc: 库存转移单及明细QP
 */
@Data
@ApiModel(value = "inv_trn", description = "库存转移单及明细QP")
public class InvTrnAllQueryParamVO extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = 712025221056806665L;
    @ApiModelProperty("从仓库ids")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> oWhIds;

    @ApiModelProperty("至仓库ids")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> iWhIds;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    String deter1;

    @ApiModelProperty("从功能区")
    List<String> iDeter2s;

    @ApiModelProperty("至功能区")
    List<String> oDeter2s;

    @ApiModelProperty("品项ids")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> itemIds;

    @ApiModelProperty("原因码 [UDC]COM:APPR_STATUS")
    String reasonCode;

    @ApiModelProperty("转移单状态 [UDC]INV:TRN_STATUS")
    String docStatus;

    @ApiModelProperty("交易日期 实际出入库日期")
    List<LocalDateTime> ioDates;

    @ApiModelProperty("公司ids")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> ouIds;

    @ApiModelProperty("单据编号")
    String docNo;
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long createUserId;

    @ApiModelProperty("记录创建者ID列表")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long>createUserIds;

    @ApiModelProperty("创建日期起")
    LocalDateTime createDateStart;

    @ApiModelProperty("创建日期止")
    LocalDateTime createDateEnd;
    @ApiModelProperty("外部单据编号")
    String outerNo;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("从库存合作伙伴编码")
    String oPCode;

    @ApiModelProperty("至库存合作伙伴编码")
    String iPCode;

    @ApiModelProperty("创建时间-起")
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private LocalDateTime createTimeStart;

    @ApiModelProperty("创建时间-止")
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private LocalDateTime createTimeEnd;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("功能区关键字查询")
    private String oDeter2KeyWord;

    @ApiModelProperty("至能区关键字查询")
    private String iDeter2KeyWord;

}
