package com.elitesland.yst.production.inv.application.facade.vo.invTrn;


import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author jeesie.jia ng
 * @date 2021-03-17 11:13
 * Desc: 库内转移单及明细VO
 */
@Data
@ApiModel(value = "INV_TRN_TRND", description = "库存转移及明细")
public class InvTrnAndTrnRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -4731711854801898617L;

    // 主表信息
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long ouId;
    @ApiModelProperty("公司名称")
    String ouName;

    @ApiModelProperty("公司编码")
    String ouCode;

    @ApiModelProperty("单据编号")
    String docNo;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long buId;

    @ApiModelProperty("转移类型 [UDC]INV:TRN_TYPE")
    String docType;
    String docTypeName;

    @ApiModelProperty("转移单状态 [UDC]INV:TRN_STATUS")
    String docStatus;
    @ApiModelProperty("转移单状态名称")
    String docStatusName;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    String reasonCode;
    @ApiModelProperty("转移原因")
    String reasonCodeName;

    @ApiModelProperty("申请日期")
    LocalDateTime applyDate;

    @ApiModelProperty("交易日期 实际出入库日期")
    LocalDateTime ioDate;

    // 明细表信息
    @ApiModelProperty("单据编号")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("行号")
    Double lineNo;

    @ApiModelProperty("行状态")
    String lineStatus;

    @ApiModelProperty("行类型")
    String lineType;

    @ApiModelProperty("从公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long oOuId;
    String oOuName;



    @ApiModelProperty("从仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long oWhId;
    @ApiModelProperty("从仓库code")
    String oWhCode;
    @ApiModelProperty("从仓库名称")
    String oWhName;

    @ApiModelProperty("从温层 [UDC]INV:TEMP_TYPE")
    String oDeter1;
    String oDeter1Name;

    @ApiModelProperty("从功能区code [UDC]INV:FUNC_TYPE")
    String oDeter2;
    @ApiModelProperty("从功能区")
    String oDeter2Name;

    @ApiModelProperty("从客户标识")
    String oDeter3;

    @ApiModelProperty("从限定4")
    String oDeter4;

    @ApiModelProperty("从限定5")
    String oDeter5;

    @ApiModelProperty("从限定6")
    String oDeter6;

    @ApiModelProperty("从限定7")
    String oDeter7;

    @ApiModelProperty("从限定8")
    String oDeter8;

    @ApiModelProperty("到公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long iOuId;

    @ApiModelProperty("到仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long iWhId;
    @ApiModelProperty("到仓库code")
    String iWhCode;
    @ApiModelProperty("到仓库名称")
    String iWhName;

    @ApiModelProperty("到温层 [UDC]INV:TEMP_TYPE")
    String iDeter1;
    String iDeter1Name;

    @ApiModelProperty("到功能区code [UDC]INV:FUNC_TYPE")
    String iDeter2;
    @ApiModelProperty("到功能区")
    String iDeter2Name;

    @ApiModelProperty("在途功能区[UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv",mod = "FUNC_TYPE")
    String tranDeter2;
    String tranDeter2Name;

    @ApiModelProperty("到客户标识")
    String iDeter3;

    @ApiModelProperty("到限定4")
    String iDeter4;

    @ApiModelProperty("到限定5")
    String iDeter5;

    @ApiModelProperty("到限定6")
    String iDeter6;

    @ApiModelProperty("到限定7")
    String iDeter7;

    @ApiModelProperty("到限定8")
    String iDeter8;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long itemId;

    @ApiModelProperty("品牌编码")
    String brand;
    @ApiModelProperty("品牌名称")
    String brandName;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long variId;

    @ApiModelProperty("批次")
    String lotNo;

    @ApiModelProperty("序列号")
    String snNo;

    @ApiModelProperty("单位code")
    String uom;
    @ApiModelProperty("单位")
    String uomName;

    @ApiModelProperty("转移数量2")
    BigDecimal qty2;

    @ApiModelProperty("单位2")
    String uom2;

    @ApiModelProperty("单位转换率")
    Float uomRatio;

    @ApiModelProperty("单位转换率2")
    Float uomRatio2;

    @ApiModelProperty("转移数量")
    BigDecimal qty;

    @ApiModelProperty("数量单位")
    String qtyUom;

    @ApiModelProperty("税额")
    BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    String homeCurr;

    @ApiModelProperty("交易币种")
    String currCode;

    @ApiModelProperty("汇率")
    Float currRate;

    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    BigDecimal currAmt;

    @ApiModelProperty("单位成本")
    BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    BigDecimal costAmt;

    @ApiModelProperty("关联单据类别 如RMA。[UDC]COM:DOC_CLS")
    String relateDocCls;
    String relateDocClsName;

    @ApiModelProperty("关联单据类型")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    String relateDocNo;

    @ApiModelProperty("关联单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relateDocDid;

    @ApiModelProperty("关联单据行号")
    Float relateDocLineno;

    // gr
    @ApiModelProperty("商品编号")
    String itemCode;

    @ApiModelProperty("商品名称")
    String itemName;

    @ApiModelProperty("外部单据编号")
    String outerNo;

    @ApiModelProperty("外部单据行号")
    String outerLineno;

    @ApiModelProperty("外部单据公司")
    String outerOu;

    @ApiModelProperty("外部单据类型")
    String outerType;

    @ApiModelProperty("从仓库库存可用量")
    BigDecimal avalQty;

    @ApiModelProperty("创建人")
    String createUserName;

    @ApiModelProperty("从库存合作伙伴编码")
    String oPCode;

    @ApiModelProperty("至库存合作伙伴编码")
    String iPCode;

    @ApiModelProperty("库存合作伙伴类型")
    String oPType;

    @ApiModelProperty("库存合作伙伴类型")
    String iPType;
    @ApiModelProperty("库存合作伙伴类型")
    String oPName;

    @ApiModelProperty("库存合作伙伴类型")
    String iPName;

    @ApiModelProperty("库存合作伙伴类型名")
    String oPTypeName;

    @ApiModelProperty("库存合作伙伴类型名")
    String iPTypeName;

    @ApiModelProperty("明细权限id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secdBuId;

    @ApiModelProperty("明细数据归属账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secdUserId;

    @ApiModelProperty("明细数据归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secdOuId;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    public String getProcInstStatusName() {
        return procInstStatus != null ? procInstStatus.getDesc() : null;
    }

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    /**
     * 审批状态 [UDC]COM:APPR_STATUS
     */
    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    @SysCode(sys = "COM", mod = "APPR_STATUS")
    private String apprStatus;
    @ApiModelProperty("审批状态名称")
    private String apprStatusName;

    @ApiModelProperty("京云仓采购入库单号")
    private String jdPoOrderNo;

    @ApiModelProperty("从包")
    String olimit1;

    @ApiModelProperty("到包")
    String ilimit1;

    @ApiModelProperty("单据类别")
    private String docCls;



}
