package com.elitesland.yst.production.inv.application.facade.vo.invTrn;

import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnDRespVO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author lvqf
 * @Date 2021/3/4
 * @Description
 */
@Data
public class InvTrnDetailRespVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 8636045282144644569L;
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long ouId;

    @ApiModelProperty("公司编码")
    String ouCode;

    @ApiModelProperty("公司名")
    String ouName;

    @ApiModelProperty("从公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long oOuId;

    @ApiModelProperty("到公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long iOuId;

    @ApiModelProperty("申请日期")
    LocalDateTime applyDate;

    @ApiModelProperty("从仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long oWhId;
    @ApiModelProperty("从仓库code")
    String oWhCode;
    @ApiModelProperty("从仓库名称")
    String oWhName;

    @ApiModelProperty("到仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long iWhId;
    @ApiModelProperty("到仓库code")
    String iWhCode;
    @ApiModelProperty("到仓库")
    String iWhName;

    @ApiModelProperty("从功能区code [UDC]INV:FUNC_TYPE")
    String oDeter2;
    @ApiModelProperty("从功能区")
    String oDeter2Name;

    @ApiModelProperty("到功能区code [UDC]INV:FUNC_TYPE")
    String iDeter2;
    @ApiModelProperty("到功能区")
    String iDeter2Name;

    @ApiModelProperty("单据编号")
    String docNo;

    @ApiModelProperty("转移单状态code [UDC]INV:TRN_STATUS")
    String docStatus;
    @ApiModelProperty("转移单状态")
    String docStatusName;

    @ApiModelProperty("交易日期 实际出入库日期")
    LocalDateTime ioDate;

    @ApiModelProperty("原因码code [UDC]COM:REASON_CODE")
    String reasonCode;

    @ApiModelProperty("转移原因")
    String reasonCodeName;

    @ApiModelProperty("创建人")
    String createUserName;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    public String getProcInstStatusName() {
        return procInstStatus != null ? procInstStatus.getDesc() : null;
    }

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    /**
     * 审批状态 [UDC]COM:APPR_STATUS
     */
    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    @SysCode(sys = "COM", mod = "APPR_STATUS")
    private String apprStatus;
    @ApiModelProperty("审批状态名称")
    private String apprStatusName;

    @ApiModelProperty("行号")
    private Double lineNo;
    @ApiModelProperty("单据类别")
    private String docCls;

    List<InvTrnDRespVO> invTrnDRespVOList;
}
