package com.elitesland.yst.production.inv.application.facade.vo.invstk;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
/**
 * 进销存数据
 */
public class InvStkIOSaveVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 5175394486118648070L;

    @ApiModelProperty("当前库存数目")
    private BigDecimal ohQty;

    @ApiModelProperty("当期应存")
    private BigDecimal thQty;

    @ApiModelProperty("当前成本")
    private BigDecimal amt;

    @ApiModelProperty("收货入")
    private BigDecimal grIQty;

    @ApiModelProperty("收货入成本")
    private BigDecimal grINetAmt;

    @ApiModelProperty("收货入含税")
    private BigDecimal griAmt;

    @ApiModelProperty("销退入")
    private BigDecimal saBaIQty;

    @ApiModelProperty("销退入成本")
    private BigDecimal saBaINetAmt;

    @ApiModelProperty("移库入")
    private BigDecimal trnIQty;

    @ApiModelProperty("移库入成本")
    private BigDecimal trnINetAmt;

    @ApiModelProperty("组装入")
    private BigDecimal asmIQty;

    @ApiModelProperty("组装入成本")
    private BigDecimal asmINetAmt;

    @ApiModelProperty("调整增")
    private BigDecimal ajGQty;

    @ApiModelProperty("调整增成本")
    private BigDecimal ajGNetAmt;

    @ApiModelProperty("销售出")
    private BigDecimal saleOQty;

    @ApiModelProperty("损销售出成本")
    private BigDecimal deSaleONetAmt;

    @ApiModelProperty("调整出")
    private BigDecimal ajOQty;

    @ApiModelProperty("调整出成本")
    private BigDecimal ajONetAmt;

    @ApiModelProperty("采购退货出")
    private BigDecimal purReOQty;

    @ApiModelProperty("采购退货出成本")
    private BigDecimal purReONetAmt;

    @ApiModelProperty("采购退货出含税")
    private BigDecimal purReOAmt;

    @ApiModelProperty("移库出")
    private Double trnOQty;

    @ApiModelProperty("移库出成本")
    private BigDecimal trnONetAmt;

    @ApiModelProperty("组装出")
    private Double asmOQty;

    @ApiModelProperty("组装出成本")
    private BigDecimal asmONetAmt;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("BU")
    private Long buId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("品项")
    private Long itemId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品名")
    private String itemName;

    @ApiModelProperty("包装规格")
    private String packageSpec;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("交易日期")
    private LocalDateTime ioDate;

    @ApiModelProperty("仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    private String deter1;
    private String deter1Name;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    private String deter2Name;

    @ApiModelProperty("客户标识")
    private String deter3;

    @ApiModelProperty("单位")
    @SysCode(sys = "COM", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("来源单据类别")
    private String srcDocCls;

    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;

    @ApiModelProperty("来源单据编号")
    private String srcDocNo;

    @ApiModelProperty("操作类型")
    private String ioName;
}
