package com.elitesland.yst.production.inv.application.facade.vo.invwh;


import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-05-28 14:00:46
 */
@Data
@ApiModel(value = "inv_wh_delivery", description = "仓库配送范围")
public class InvWhDeliveryRespVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 8431620400854664602L;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;


    @ApiModelProperty("省编码")
    private String pcode;

    @ApiModelProperty("省")
    private String pname;


    @ApiModelProperty("市编码")
    private String ccode;

    @ApiModelProperty("市")
    private String cname;

    /**
     * aCode
     */
    @ApiModelProperty("区（县）编码")
    private String acode;

    @ApiModelProperty("区（县)")
    private String aname;

    /**
     * sCode
     */
    @ApiModelProperty("乡编码")
    private String scode;

    /**
     * sCode
     */
    @ApiModelProperty("乡")
    private String sname;

    @ApiModelProperty("全国")
    private Integer allArea;

    @ApiModelProperty("全国")
    private String allAreaName;




}
