package com.elitesland.yst.production.inv.application.facade.vo.invwh;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author yifansir.jin
 * @since 2021-05-28 14:00:46
 */
@Data
@ApiModel(value = "inv_wh_delivery", description = "仓库配送范围")
public class InvWhDeliverySaveVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = -7836927721495977580L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;


    @ApiModelProperty("省编码")
    private String pCode;

    @ApiModelProperty("省编码")
    private String pName;


    @ApiModelProperty("市编码")
    private String cCode;

    @ApiModelProperty("市编码")
    private String cName;

    /**
     * aCode
     */
    @ApiModelProperty("区（县）编码")
    private String aCode;


    /**
     * aCode
     */
    @ApiModelProperty("区（县）编码")
    private String aName;

    /**
     * sCode
     */
    @ApiModelProperty("乡编码")
    private String sCode;


    /**
     * aCode
     */
    @ApiModelProperty("区（县）编码")
    private String sName;

    /**
     * aCode
     */
    @ApiModelProperty("是否配送全国")
    private Integer allArea;

    /**
     * aCode
     */
    @ApiModelProperty("是否配送全国")
    private String allAreaName;

    @ApiModelProperty("外部仓库类型")
    private String otherWhType;

    @ApiModelProperty("外部仓库类型编码")
    private String otherWhCode;

    @ApiModelProperty("所属组织类型")
    private String belongBuType;

    @ApiModelProperty("所属组织")
    private String belongBuId;

}
