package com.elitesland.yst.production.inv.application.facade.vo.invwh;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;

@EqualsAndHashCode(callSuper = true)
@Data
public class InvWhRptRespVO extends InvWhRespVO {
    private static final long serialVersionUID = -3916691533902536129L;

    @ApiModelProperty("唯一id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    private String deter1;
    private String deter1Name;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("功能区名")
    private String deter2Name;

    @ApiModelProperty("ERP编号")
    @SysCode(sys = "yst-inv", mod = "E1_BP")
    private String outerCode;

    @ApiModelProperty("ERP名称")
    private String outerCodeName;
    /**
     * E1库区编号
     */
    @ApiModelProperty("E1库区编号")
    @SysCode(sys = "yst-inv", mod = "E1_LOC")
    private String outerCode2;
    private String outerCode2Name;

    //薛东辉 2020/12/1
    @ApiModelProperty("客户编号")
    private String custCode;
    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("库存合作伙伴名称")
    private String pName;

    @ApiModelProperty("库存合作伙伴类型")
    private String pType;


    @ApiModelProperty("客户标识")
    private String deter3;





}
