package com.elitesland.yst.production.inv.application.facade.vo.invwh;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2020-08-31
 */
@Data
@ApiModel(value = "仓库下拉 返回id、code、name,physicalWhCode，deter1,deter2,temperature", description = "仓库下拉 返回id、code、name,physicalWhCode，deter1,deter2,temperature")
public class InvWhSalListRespVO extends BaseModelVO implements Serializable {


    private static final long serialVersionUID = -8893518665885084610L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库id")
    private Long id;
    /**
     * 仓库编号
     */
    @ApiModelProperty("仓库编号")
    private String whCode;
    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    // 2020.08.11 roamn.zhang add
    @ApiModelProperty("实体仓库")
    private String physicalWhCode;

    // 2020.08.18 roamn.zhang add
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    private String deter1;
    private String deter1Name;

    // 2020.08.31 roamn.zhang add
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    private String deter2Name;

    // 2020.12.09 roamn.zhang add
    @ApiModelProperty("客户标识UDC待定 [UDC]INV:FUNC_TYPE")
//    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter3;
    private String deter3Name;

    @ApiModelProperty("功能区对应的温度")
    private String temperature;

    // 2020.08.24 roamn.zhang add
    @ApiModelProperty("发货地址")
    private String fromLoc;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    //2020.8.25 liuqi add
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;


    @ApiModelProperty("供应商合作公司")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateOuId;

    @ApiModelProperty("供应商合作公司编码")
    private String relateOuCode;

    @ApiModelProperty("仓库对应的功能区")
    private List<InvWhAreaRespVO> invWhAreaRespVOS;

    /**
     * 附件标识
     */
    @ApiModelProperty("附件标识fileCode")
    private String fileCode;
}
