package com.elitesland.yst.production.inv.application.facade.vo.scene.param;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.yst.production.inv.enums.WhetherEnum;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitesland.yst.production.inv.utils.InvStringUtil;
import com.elitescloud.boot.exception.BusinessException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.val;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.List;

/**
 * @author Tom.su
 * @program yst-inv
 * @description
 * @date 2022/04/20 18:12
 */
@ApiModel(description = "库存场景传输类")
@Data
public class InvSceneConfigSaveParam extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = -9172927634362072762L;

    @ApiModelProperty("记录唯一ID,更新时必传")
    private Long id;

    @ApiModelProperty("库存场景码")
    private String sceneCode;

    @ApiModelProperty("库存场景描述，限定长度60中文字符之内")
    private String sceneDesc;

    @ApiModelProperty("触发单据类型")
    @Column(name = "opt_doc_type", columnDefinition = "varchar(40)  comment '触发单据类型'")
    private String optDocType;


    @ApiModelProperty("触发单据操作描述")
    private String optDocDesc;

    @ApiModelProperty("启用状态  Y-是 N-否")
    private String isEnable;

    public List<InvSceneConfigDtl> invSceneConfigDtlList;

    public void setLine() {
        if(CollectionUtil.isEmpty(invSceneConfigDtlList)){
            return;
        }
        for (int i = 0; i < invSceneConfigDtlList.size(); i++) {
            val invSceneConfigDtl = invSceneConfigDtlList.get(i);
            invSceneConfigDtl.setLineNo(i + 1);
        }
    }

    @Data
    @ApiModel(description = "库存场景明细传输类")
    public static class InvSceneConfigDtl extends BaseModelVO implements Serializable {

        private static final long serialVersionUID = 3646590805204768500L;

        @ApiModelProperty(hidden = true)
        private Integer lineNo;

        @ApiModelProperty(hidden = true)
        private Long masId;

        @ApiModelProperty(value = "操作码")
        private String ioCode;

        @ApiModelProperty(value = "操作类型")
        private String ioType;

        @ApiModelProperty(value = "操作描述,限长200位")
        private String optDesc;

        @ApiModelProperty(value = "执行序列")
        private Integer optSeq;

        @ApiModelProperty(value = "关联单据是否必传 Y-是 N-否")
        private String isRelDocReq;

        @ApiModelProperty(value = "是否使用关联单据操作库存 Y-是 N-否")
        private String isUseRelDoc;

        @ApiModelProperty(value = "库存操作体")
        private String whoptType;

        @ApiModelProperty(value = "关联单据类型")
        private String relDocType;

        @ApiModelProperty(value = "指定功能区编码")
        private String deter2;

        public void setIsRelDocReq(String isRelDocReq) {
            this.isRelDocReq = StringUtils.isBlank(isRelDocReq) ? WhetherEnum.N.name() : isRelDocReq;
        }

        public void setIsUseRelDoc(String isUseRelDoc) {
            this.isUseRelDoc = StringUtils.isBlank(isUseRelDoc) ? WhetherEnum.N.name() : isUseRelDoc;
        }
    }

    public void validateBodyBySave(List<InvSceneConfigSaveParam.InvSceneConfigDtl> paramList) {
        for (int i = 0; i < paramList.size(); i++) {
            InvSceneConfigSaveParam.InvSceneConfigDtl configDtl = paramList.get(i);
            /**2023-02-10 :按照产品要求，库存操作参数非必填**/
//            if(StringUtils.isBlank(configDtl.getWhoptType())){
//                throw new BusinessException("库存操作参数选择不能为空,行号：" + configDtl.getLineNo());
//            }

            if (StringUtils.isBlank(configDtl.getIoCode())) {
                throw new BusinessException("操作码不能为空,行号：" + configDtl.getLineNo());
            }
            if (StringUtils.isBlank(configDtl.getIoType())) {
                throw new BusinessException("操作类型不能为空,行号：" + configDtl.getLineNo());
            }
            if (StringUtils.isNotBlank(configDtl.getOptDesc())) {
                if (InvStringUtil.lengthOfUTF8(configDtl.getOptDesc()) > 200) {
                    throw new BusinessException("操作描述，限定长度60中文字符之内,行号：" + configDtl.getLineNo());
                }
            }
            if (!WhetherEnum.Y.name().equals(configDtl.getIsRelDocReq()) && !WhetherEnum.N.name().equals(configDtl.getIsRelDocReq())) {
                throw new BusinessException("关联单据是否必传不合法,行号：" + configDtl.getLineNo());
            }
            if (!WhetherEnum.Y.name().equals(configDtl.getIsUseRelDoc()) && !WhetherEnum.N.name().equals(configDtl.getIsUseRelDoc())) {
                throw new BusinessException("是否使用关联单据操作库存不合法,行号：" + configDtl.getLineNo());
            }
            if (WhetherEnum.Y.name().equals(configDtl.getIsRelDocReq())) {
                if (StringUtils.isBlank(configDtl.getRelDocType())) {
                    throw new BusinessException("关联单据如果必传，关联单据类型则必填,行号：" + configDtl.getLineNo());
                }
            }
        }
    }

    public void validateHeadBySave(InvSceneConfigSaveParam param) {
        if (StringUtils.isBlank(param.getSceneCode())) {
            throw new BusinessException("库存场景码不能为空");
        }
        if (StringUtils.isNotBlank(param.getSceneDesc())) {
            if (InvStringUtil.lengthOfUTF8(param.getSceneDesc()) > 200) {
                throw new BusinessException("库存场景描述，限定长度60中文字符之内");
            }
        }
        if (StringUtils.isBlank(param.getSceneDesc())) {
            throw new BusinessException("库存场景描述");
        }
        if (StringUtils.isBlank(param.getOptDocType())) {
            throw new BusinessException("触发单据类型不能为空");
        }
        if (StringUtils.isBlank(param.getOptDocDesc())) {
            throw new BusinessException("触发单据操作描述不能为空");
        }
        if (StringUtils.isBlank(param.getIsEnable())) {
            throw new BusinessException("启用状态不能为为空");
        }
        if (!WhetherEnum.Y.name().equals(param.getIsEnable()) && !WhetherEnum.N.name().equals(param.getIsEnable())) {
            throw new BusinessException("启用状态不合法");
        }

    }

    public void validateHeadByUpdate(InvSceneConfigSaveParam param) {
        if (param.getId() == null) {
            throw new BusinessException("更新时库存场景主键不能为空");
        }
        if (StringUtils.isNotBlank(param.getSceneDesc())) {
            if (InvStringUtil.lengthOfUTF8(param.getSceneDesc()) > 200) {
                throw new BusinessException("库存场景描述，限定长度60中文字符之内");
            }
        }
        if (StringUtils.isNotBlank(param.getIsEnable())) {
            if (!WhetherEnum.Y.name().equals(param.getIsEnable()) && !WhetherEnum.N.name().equals(param.getIsEnable())) {
                throw new BusinessException("启用状态不合法");
            }
        }

    }

}
