package com.elitesland.yst.production.inv.application.out;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.SysOrgPageQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysOrgPageRespDTO;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/06/26
 * @Version 1.0
 * @Content:
 */
@Service
@AllArgsConstructor
@Slf4j
public class OrgBuOutServiceImpl implements OrgBuOutService {

    private final OrgRpcService orgRpcService;


    /**
     * 查询组织基础信息接口
     *
     * @param codes
     * @return
     */
    @Override
    public List<IdCodeNameParam> findSimpleBuByCodes(Set<String> codes) {
        //log.info("调用系统域(findSimpleBuByCodes)查询组织，时间：{}，入参：{}", LocalDateTime.now(), JSON.toJSONString(codes));
        if (CollectionUtil.isEmpty(codes)) {
            return Collections.EMPTY_LIST;
        }
        try {
            ApiResult<List<IdCodeNameParam>> apiResult = orgRpcService.queryIdAndName(codes);
            //log.info("调用系统域(findSimpleBuByCodes)查询组织，时间：{}，出参：{}", LocalDateTime.now(), JSON.toJSONString(apiResult));
            if (apiResult.isSuccess()) {
                List<IdCodeNameParam> apiResultData = apiResult.getData();
                if (CollectionUtil.isNotEmpty(apiResultData)) {
                    return apiResultData;
                }
            } else {
                throw new BusinessException(ApiCode.FAIL, "调用系统域(findSimpleBuByCodes)查询组织失败：" + apiResult.getErrorMsg());
            }
        } catch (Exception e) {
            log.error("findSimpleBuByCodes error:", e);
            throw new BusinessException(ApiCode.FAIL, "调用系统域dubbo服务异常：" + e);
        }

        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String,IdCodeNameParam> findBuMapByCodes(Set<String> codes) {

        List<IdCodeNameParam> buList = this.findSimpleBuByCodes(codes);
        if (CollectionUtil.isEmpty(buList)) {
            return new HashMap<>();
        }
        Map<String, IdCodeNameParam> buMap = buList.stream().collect(Collectors.toMap(IdCodeNameParam::getCode, t -> t, (t1, t2) -> t1));

        return buMap;

    }


    /**
     * 查询组织分页接口
     *
     * @param pageQueryDTO
     * @return
     */
    @Override
    public PagingVO<SysOrgPageRespDTO> queryBuPageByParam(SysOrgPageQueryDTO pageQueryDTO) {
        //log.info("调用系统域(queryBuPageByParam)查询组织分页接口，时间：{}，入参：{}", LocalDateTime.now(), JSON.toJSONString(pageQueryDTO));

        try {
            ApiResult<PagingVO<SysOrgPageRespDTO>> apiResult = orgRpcService.queryPage(pageQueryDTO);
            //log.info("调用系统域(queryBuPageByParam)查询组织分页接口，时间：{}，出参：{}", LocalDateTime.now(), JSON.toJSONString(apiResult));
            if (apiResult.isSuccess()) {
                PagingVO<SysOrgPageRespDTO> pagingVO = apiResult.getData();
                return pagingVO;
            } else {
                throw new BusinessException(ApiCode.FAIL, "调用系统域(queryBuPageByParam)查询组织分页失败：" + apiResult.getErrorMsg());
            }
        } catch (Exception e) {
            log.error("queryBuPageByParam error:", e);
            throw new BusinessException(ApiCode.FAIL, "调用系统域dubbo服务异常：" + e);
        }

    }

}
