package com.elitesland.yst.production.inv.application.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrSaveVO;

import java.util.List;


/**
 * @author feng
 * @program: yst-inv
 * @description: 承运商配送单
 * @date 2021-09-19 12:01:20
 */
public interface InvCarrService {

    /**
     * 保存/提交配送单
     * @param invCarrSaveVO
     * @return
     */
    Long saveInvCarr(InvCarrSaveVO invCarrSaveVO, boolean isSubmit);

    /**
     * 配送单详情
     * @param id
     * @return
     */
    InvCarrRespVO detail(Long id);

    /**
     * 列表查询
     * @param invCarrParamVO
     * @return
     */
    PagingVO<InvCarrRespVO> list(InvCarrParamVO invCarrParamVO);

    /**
     * 删除配送单
     * @param id
     */
    void deleteInvCarr(Long id);

    void commitInvCarr(List<Long> ids);

    /**
     * 根据id修改状态
     * @param ids
     * @param docStatus
     */
    void updateInvCarrStatus(List<Long> ids, String docStatus);

    /**
     * 根据发货单id修改单据状态
     * @param relateDocId
     * @param docStatus
     */
    void updateInvCarrStatusByRelateDocId(Long relateDocId,String docStatus);


}
