package com.elitesland.yst.production.inv.application.service;

import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionParam;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.*;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaRpcDTO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
import java.util.Optional;

public interface InvWhAreaService {
    /**
     * 分页查询仓库
     * @param param 过滤条件
     * @return 仓库
     */
    PagingVO<InvWhRespVO> searchWh(InvWhParamVO param);

    List<InvWhRespVO> searchWhByParam(InvWhParamVO paramVO);

    Optional<InvWhAreaRespVO> findIdOne(Long id);

    /**
     * 根据仓库id获取库区
     * @param whIds
     * @return
     */
    List<InvWhAreaRespVO> findAllByWhId(List<Long> whIds);

    /**
     * 查询库区
     * @param paramVO
     * @return
     */
    List<InvWhAreaRespVO> findWhAreasByParam(InvWhAreaParamVO paramVO);

    /**
     * 检索
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<InvWhAreaRespVO> search(InvWhAreaParamVO queryParam);

    /**
     * 创建
     * @param list 对象集合
     */
    List<Long> createBatch(List<InvWhAreaSaveVO> list);

    /**
     * 更新
     * @param  objDo 对象
     */
    void update(InvWhAreaSaveVO objDo) ;

    /**
     * 根据仓库id 列表批量查询库区
     * @param whIds
     * @return
     */
    List<InvWhAreaRpcDTO> findWhAreaRpcDTOByWhIds(List<Long> whIds);

    List<SelectOptionVO> listDeter2(SelectOptionParam param);

    List<InvWhAreaRespVO> findBydeter2AndDeter2Type(String deter2,String deter2Type);





}
