package com.elitesland.yst.production.inv.application.service;


import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionParam;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingSaveVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 功能说明:功能区配置
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */
public interface InvWhAreaSettingService {

    /**
     * 新增功能区配置数据
     *
     * @param saveVo 新增功能区配置数据
     * @return 新增功能区配置ID
     */
    ApiResult<Long> createOne(InvWhAreaSettingSaveVO saveVo);

    /**
     * 修改功能区配置数据
     *
     * @param saveVo 修改功能区配置对象
     * @return 功能区配置ID
     */
    ApiResult<Long> update(InvWhAreaSettingSaveVO saveVo);

    /**
     * 通过功能区配置ID查询单条数据
     *
     * @param id 功能区配置ID
     * @return 单条功能区配置数据
     */
    ApiResult<InvWhAreaSettingRespVO> findIdOne(Long id);

    /**
     * 通过功能区编码查询单条数据
     *
     * @param deter2 功能区编码
     * @return 单条功能区配置数据
     */
    Optional<InvWhAreaSettingRespVO> findByDeter2(String deter2);

    List<InvWhAreaSettingRespVO> findByDeter2s(List<String> deter2);

    List<InvWhAreaSettingRespVO> findByDeter2Types(List<String> deter2Types);

    /**
     * 通过功能区编码集合查询数据
     *
     * @param deter2List 功能区编码集合
     * @return 功能区配置数据集合
     */
    List<InvWhAreaSettingRespVO> findByDeter2Batch(List<String> deter2List);

    /**
     * 分页查询功能区配置
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条功能区配置数据
     */
    PagingVO<InvWhAreaSettingRespVO> search(InvWhAreaSettingParamVO param);

    /**
     * 根据功能区配置ID批量逻辑删除
     *
     * @param ids 功能区配置ID集合
     * @return 功能区配置ID集合
     */
    ApiResult<String> deleteBatch(List<Long> ids);

    /**
     * 功能描述 查询所有生效的数据
     *
     * @param
     * @return
     * @author Brian.lai
     * @date 2021/7/6
     */
    List<InvWhAreaSettingRespVO> findAllActives(InvWhAreaSettingParamVO paramVO);

    List<SelectOptionVO> listDeter2Type(SelectOptionParam select);
}
