package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.domain.entity.ck.QInvCkDO;
import com.elitesland.yst.production.inv.domain.service.InvCkDomainService;
import com.elitesland.yst.production.inv.infr.dto.ck.InvCkDTO;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.application.service.InvCkProcessService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @ClassName InvCkProcessServiceImpl
 * @Description TODO
 * @Auther Brian.lai
 * @Date 2022/2/18 14:01
 * @Version 1.0
 **/
@Service
@AllArgsConstructor
public class InvCkProcessServiceImpl implements InvCkProcessService {
    private final JPAQueryFactory jpaQueryFactory;
    //private final InvCkRepo invCkRepo;
    private final SystemService systemService;
    private final InvCkDomainService invCkDomainService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(long id, ProcInstStatus procInstStatus) {
        //1,查询单据是否存在
        Optional<InvCkDTO> invCkDTOOptional = invCkDomainService.findById(id);
        if (invCkDTOOptional.isPresent() == false) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }
        QInvCkDO qInvCkDO = QInvCkDO.invCkDO;

        //2,修改审批状态
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qInvCkDO)
                .set(qInvCkDO.procInstStatus, procInstStatus)
                .where(qInvCkDO.id.eq(id));

        //3,修改单据状态
        switch (procInstStatus) {
            case NOTSUBMIT:
            case INTERRUPT:
                jpaUpdateClause.set(qInvCkDO.docStatus, UdcEnum.INV_CK_STATUS_DR.getValueCode());
                break;
            // 审批拒绝
            case REJECTED:
                jpaUpdateClause.set(qInvCkDO.docStatus, UdcEnum.INV_CK_STATUS_RJ.getValueCode());
                break;
            // 作废
            case INVALID:
                jpaUpdateClause.set(qInvCkDO.docStatus, UdcEnum.INV_CK_STATUS_CL.getValueCode());
                break;
            // 审批中
            case APPROVING:
                jpaUpdateClause.set(qInvCkDO.docStatus, UdcEnum.INV_CK_STATUS_APPING.getValueCode());
                break;
            case APPROVED:
                jpaUpdateClause.set(qInvCkDO.docStatus, UdcEnum.INV_CK_STATUS_APPED.getValueCode())
                        .set(qInvCkDO.approvedTime, LocalDateTime.now())
                        .set(qInvCkDO.apprUserId, SecurityContextUtil.currentUserId())
                        .set(qInvCkDO.apprUserName,SecurityContextUtil.currentUserName())

                ;
                break;
            default:
                break;

        }
        //执行
        jpaUpdateClause.execute();
    }

    @Override
    public ArrayList<String> taskAssignee(Long id, String customParams) {
        List<Long> userIds = systemService.findUserIdsByFlowRoles(id, customParams);
        ArrayList<String> userStrIds = new ArrayList<>();
        if (!CollectionUtils.isEmpty(userIds)) {
            userIds.stream().forEach(i -> {
                String newString = String.valueOf(i);
                userStrIds.add(newString);
            });
            return userStrIds;
        }
        return null;
    }
}
