package com.elitesland.yst.production.inv.application.service.impl;

import com.elitesland.yst.production.inv.application.facade.vo.InvStkCommon28InSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvStkCommon37InSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkGroupRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvIoService;
import com.elitesland.yst.production.inv.application.service.InvStkCommonService;
import com.elitesland.yst.production.inv.application.service.InvStkService;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvCommonConvert;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvStkConvert;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvIoDO;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkDO;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.utils.InvStk28Enum;
import com.elitesland.yst.production.inv.utils.NumSendObjectEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.redisson.RedissonRedLock;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;


/**
 * <p>
 * 库存共通方法
 * </p>
 *
 * @author jeesie.jiang
 * @since 2022-03-24
 */
@Service("invStkCommonService")
@Slf4j
@AllArgsConstructor
public class InvStkCommonServiceImpl implements InvStkCommonService {

    private final ItmOutService itmOutService;
    private final InvWhDomainService invWhService;
    private final InvStkService invStkService;
    private final OrgOutService outouService;
    private final RedLockUtils redLockUtils;

    private final SystemService systemService; //发号

    private final InvIoService invIoService;


    @Override
    public InvStkRespVO getInvStk(InvBaseModel queryParam) {
        InvStkRespVO invStk = invStkService.getInvStk(queryParam);
        return invStk;
    }

    @Override
    public InvStkRespVO getInvGroupStk(InvBaseModel queryParam) {
        InvStkGroupRespVO results = invStkService.getInvStkGroupByParam(queryParam);
        if(results != null) {
            InvStkRespVO respVO = InvStkConvert.INSTANCE.stkGroupRespVOToStkRespVO(results);
            return respVO;
        }
        return null;
    }

    @Override
    @Transactional
    public void invStkCommon28(List<InvStkCommon28InSaveVO> common28InVOList) {
        log.info("共通方法28，时间：{}，入参：{}", LocalDateTime.now(), String.join(",", common28InVOList.stream().map(InvStkCommon28InSaveVO::toString).collect(Collectors.toList())));
        doProcess(common28InVOList, false);

    }

    @Override
    public void invStkCommon37(List<InvStkCommon37InSaveVO> common37InVOList) {
        log.info("共通方法37，时间：{}，入参：{}", LocalDateTime.now(), String.join(",", common37InVOList.stream().map(InvStkCommon37InSaveVO::toString).collect(Collectors.toList())));
        List<InvStkCommon28InSaveVO> common28InVOList =
                common37InVOList.stream().map(i -> InvCommonConvert.INSTANCE.InvStkCommon37InVOToInvStkCommon28InVO(i))
                        .collect(Collectors.toList());
        doProcess(common28InVOList, true);

    }


    public void doProcess(List<InvStkCommon28InSaveVO> common28InVOList, boolean invStkThrowExcFlag) {
        // 校验入参是否正确
        common28InVOList.forEach(inVO -> {
            if (StringUtils.isEmpty(inVO.getSrcDocCls()) || StringUtils.isEmpty(inVO.getDocNo())
                    || StringUtils.isEmpty(inVO.getSrcDocId()) || StringUtils.isEmpty(inVO.getSrcDocDid())) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "参数错误，来源单据类别、来源单据编号、来源单据ID、来源单据明细ID 均不能为空");
            }
            if (StringUtils.isEmpty(inVO.getUom())) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "参数错误，商品单位不能为空");
            }

        });
        // 去掉qty 为null 或 0 的数据
        common28InVOList = common28InVOList.stream().filter(inVO -> inVO.getQty() != null && inVO.getQty().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        // 参数赋值
        List<ItmItemRpcDTO> itmItemVOS = getItmItemVOList(common28InVOList);
        List<InvWhRespVO> orgWhVOList = invWhService.findIdBatch(common28InVOList.stream().map(InvStkCommon28InSaveVO::getWhId).distinct().collect(Collectors.toList()));
        if(CollectionUtils.isEmpty(orgWhVOList)){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "仓库不存在，请检查!");
        }
        //批次校验
        List<InvLotRespVO> invLotVOList = Collections.synchronizedList(new ArrayList<>());
        List<String> invLotStringList = common28InVOList.stream()
                .filter(i -> !StringUtils.isEmpty(i.getLotNo()))
                .map(i -> i.getItemId() == null ? "" : i.getItemId()  + "_" + (i.getVariId() == null ? "" : i.getVariId()) + "_" + i.getLotNo())
                .distinct().collect(Collectors.toList());

//        invLotStringList.stream().forEach(key ->{
//            String[] fields = key.split("_");
//            InvLotCommon21InVO invLotCommon21InVO = new InvLotCommon21InVO();
//            invLotCommon21InVO.setItemId(Long.valueOf(fields[0]));
//            invLotCommon21InVO.setVariId("".equals(fields[1]) ? null : Long.valueOf(fields[1]));
//            invLotCommon21InVO.setLotNo(fields[2]);
////            CompletableFuture<Map<Integer, List<InvLotRespVO>>> invLotFuture = CompletableFuture.supplyAsync(() -> invLotCommonService.getInvLotVOList(Arrays.asList(invLotCommon21InVO))
//            );
//            try {
//                List<InvLotRespVO> invLotList = invLotFuture.get().get(0);
//                if (CollectionUtils.isEmpty(invLotList)) {
//                    log.error("库存批次信息不存在:" + key);
//                    throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "库存批次信息不存在");
//                }
//                invLotVOList.addAll(invLotList); // 批次信息
//            } catch (InterruptedException | ExecutionException e) {
//                log.error("查询库存批次信息失败:" + key);
//                throw new BusinessException("查询库存批次信息失败");
//            }
//
//        });
        // 数据操作
        saveInvStkInfo(common28InVOList, itmItemVOS, orgWhVOList, invStkThrowExcFlag,invLotVOList);


    }


    private List<ItmItemRpcDTO> getItmItemVOList(List<InvStkCommon28InSaveVO> common28InVOList) {
        List<Long> itemIdList = common28InVOList.stream().map(InvStkCommon28InSaveVO::getItemId).distinct().collect(Collectors.toList());
        log.info("商品ID集合是：{}",itemIdList);
        if (CollectionUtils.isEmpty(itemIdList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "商品id不能为空!");
        }
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIdList);
        List<ItmItemRpcDTO> itmItemDTOS = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        if (CollectionUtils.isEmpty(itmItemDTOS)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "商品信息查询失败,商品不存在!");
        }
        return itmItemDTOS;
    }

    private void saveInvStkInfo(List<InvStkCommon28InSaveVO> common28InVOList, List<ItmItemRpcDTO> itmItemVOS, List<InvWhRespVO> orgWhVOList, boolean invStkThrowExcFlag,List<InvLotRespVO> invLotVOList){
        log.info("saveInvStkInfo 开始:common28InVOList:{},itmItemVOS:{},"
                + "orgWhVOList:{},ioBatchId:{},invStkThrowExcFlag:{}", common28InVOList,itmItemVOS,orgWhVOList,invStkThrowExcFlag);
        List<InvStkCommon28InSaveVO> invStkCreateList = Collections.synchronizedList(new ArrayList<InvStkCommon28InSaveVO>());
        common28InVOList.stream().forEach(common28InSaveVO -> {
            //查询库存
            InvStkRespVO invStkRespVO = queryInvStkAsync(common28InSaveVO);
            if(invStkThrowExcFlag){
                if(invStkRespVO == null){
                    throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "库存不存在");
                }
            }
            if (invStkRespVO == null) {
                invStkCreateList.add(common28InSaveVO);
            }
        });
        //创建库存
        if(!CollectionUtils.isEmpty(invStkCreateList)){
            invStkCreateList.stream().forEach(common28InSaveVO -> {
                InvLotRespVO lotRespVO = new InvLotRespVO();
                if(!CollectionUtils.isEmpty(invLotVOList)){
                    lotRespVO = invLotVOList.stream().filter(lot -> (lot.getItemId() + "_" + lot.getLotNo() + "_" + lot.getVariId())
                            .equals(common28InSaveVO.getItemId() + "_" + common28InSaveVO.getLotNo() + "_" + common28InSaveVO.getVariId())).findFirst().get();
                }
                //根据仓库、功能区、商品、批次号、合作伙伴类型、合作伙伴编码创建key
                String lockName = common28InSaveVO.getWhId() + "-" +common28InSaveVO.getDeter2() + "-"
                        + common28InSaveVO.getItemId() + "-" + common28InSaveVO.getLotNo() +"-"+ common28InSaveVO.getPType() + common28InSaveVO.getPCode();
                ItmItemRpcDTO itmItemVO = itmItemVOS.stream().filter(i -> i.getId().equals(common28InSaveVO.getItemId())).findAny().get();
                InvWhRespVO invWhRespVO = orgWhVOList.stream().filter(i -> i.getId().equals(common28InSaveVO.getWhId())).findAny().get();
                RedissonRedLock rLock = redLockUtils.getRedLock(lockName);
                try {
                    if ( !rLock.tryLock(-1, 60, TimeUnit.SECONDS)) {
                        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "库存并发过大,请稍后再试！");
                    }
                    //异步再次校验库存
                    InvStkRespVO invStkRespVO = queryInvStkAsync(common28InSaveVO);
                    if (invStkRespVO == null) {
                        //异步创建库存
                        createInvStkASync(common28InSaveVO, itmItemVO, invWhRespVO, lotRespVO);
                    }
                    if (!redLockUtils.isHeldByThread( lockName, Thread.currentThread().getId() )) {
                        log.error( "Lock expired after long pause" );
                        throw new BusinessException( "会话超时，请重新编辑" );
                    }
                } catch (InterruptedException e){
                    log.error("共通方法28/37，库存操作获取事务锁失败：" + e.toString());
                    throw new BusinessException("库存操作获取事务锁失败：" + e.toString());
                } finally {
                    //避免错误地解开其他线程持有的锁
                    if (redLockUtils.isHeldByThread(lockName, Thread.currentThread().getId())) {
                        log.info("释放锁{}成功",lockName);
                        rLock.unlock();
                        log.info("测试并发-释放锁名称为{}，线程名称：{}",lockName,Thread.currentThread().getName());
                    }
                }
            } );
        }
        //库存数量更新
        this.invStkOps(common28InVOList,itmItemVOS,orgWhVOList,invStkThrowExcFlag);
    }

    /**
     * 异步查询库存
     * @param common28InVO
     * @return
     */
    private InvStkRespVO queryInvStkAsync(InvStkCommon28InSaveVO common28InVO) {
        CompletableFuture<InvStkRespVO> invStkFuture = CompletableFuture.supplyAsync(() -> getInvStk(common28InVO));
        try {
            return invStkFuture.get();
        } catch (InterruptedException | ExecutionException e) {
            log.error("查询库存数据失败:" + common28InVO.toString());
            throw new BusinessException("查询库存数据失败");
        }
    }

    private void createInvStkASync(InvStkCommon28InSaveVO common28InVO,ItmItemRpcDTO itmItemVO, InvWhRespVO invWhRespVO,InvLotRespVO invLotRespVO){
        CompletableFuture  createFuture = CompletableFuture.runAsync(() -> {
            InvStkDO invStkDO = new InvStkDO();
            invStkDO.setItemId(itmItemVO.getId());
            invStkDO.setItemCode(itmItemVO.getItemCode());
            invStkDO.setUom(itmItemVO.getUom());
            invStkDO.setDeleteFlag(0);
            invStkDO.setDeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode()); //默认温层为RT
            //商品信息
            invStkDO.setItemName(itmItemVO.getItemName());
            invStkDO.setItemCateCode(itmItemVO.getItemCateCode());
            invStkDO.setBrand(itmItemVO.getBrand());
            invStkDO.setWhId(invWhRespVO.getId());
            invStkDO.setOuId(invWhRespVO.getOuId());
            //默认仓库的buId
            invStkDO.setSecBuId(invWhRespVO.getSecBuId());
            //默认仓库的secOuId
            invStkDO.setSecOuId(invWhRespVO.getSecOuId());
            invStkDO.setVariId(common28InVO.getVariId());
            invStkDO.setDeter1(common28InVO.getDeter1());
            invStkDO.setDeter2(common28InVO.getDeter2());
            invStkDO.setDeter3(common28InVO.getDeter3());
            invStkDO.setLotNo(common28InVO.getLotNo());
            invStkDO.setInDate(common28InVO.getOpDate());
            invStkDO.setPCode(common28InVO.getPCode());
            invStkDO.setPType(common28InVO.getPType());
            invStkDO.setOhQty(BigDecimal.ZERO);
            invStkDO.setOhQty2(BigDecimal.ZERO);
            invStkDO.setRsvQty(BigDecimal.ZERO);
            invStkDO.setRsvQty2(BigDecimal.ZERO);
            invStkDO.setRsvQty3(BigDecimal.ZERO);
            invStkDO.setRsvQty4(BigDecimal.ZERO);
            invStkDO.setLockQty(BigDecimal.ZERO);
            invStkDO.setLockQty2(BigDecimal.ZERO);
            invStkDO.setLockQty3(BigDecimal.ZERO);
            invStkDO.setLockQty4(BigDecimal.ZERO);
            invStkDO.setOwQty(BigDecimal.ZERO);
            invStkDO.setOwQty2(BigDecimal.ZERO);
            invStkDO.setOwQty3(BigDecimal.ZERO);
            invStkDO.setOwQty4(BigDecimal.ZERO);
            invStkDO.setAvalQty(BigDecimal.ZERO);
            invStkDO.setAvalQty2(BigDecimal.ZERO);
            invStkDO.setDeleteFlag(0);
            invStkDO.setSrcDocCls(common28InVO.getSrcDocCls()); // 来源单据类别
            invStkDO.setSrcDocId(common28InVO.getSrcDocId()); // 来源单据ID
            invStkDO.setSrcDocDid(common28InVO.getSrcDocDid()); // 来源单据明细ID
            invStkDO.setCreateUserId(common28InVO.getCreateUserId());
            invStkDO.setUntilExpireDays(invLotRespVO.getUntilExpireDays()); // 剩余效期天数  //每天自动计算
            invStkDO.setFressType(invLotRespVO.getFressType());// 新鲜度  //每天自动计算。[UDC]COM:FRESS_TYPE
            if (itmItemVO.getVolume() != null) {
                invStkDO.setVolume(itmItemVO.getVolume());
            }
            if (itmItemVO.getNetWeight() != null) {
                invStkDO.setNetWeight(itmItemVO.getNetWeight());
            }
            if (itmItemVO.getGrossWeight() != null) {
                invStkDO.setGrossWeight(itmItemVO.getGrossWeight());
            }
            invStkService.createOne(invStkDO);
        });
        try {
            createFuture.get();
        } catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }


    }

    private void invStkOps(List<InvStkCommon28InSaveVO> common28InVOS,List<ItmItemRpcDTO> itmItemVOS, List<InvWhRespVO> orgWhVOList, boolean invStkThrowExcFlag) {
        Long ioBatchId = LocalDateTime.now().toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
        common28InVOS.stream().forEach(common28InSaveVO -> {
            InvStkRespVO invStk = queryInvStkAsync(common28InSaveVO);
            if (invStkThrowExcFlag) {
                if (invStk == null) {
                    throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "库存不存在");
                }
                // 锁定库存时，可用量不能小于 锁定量
                if (common28InSaveVO.getInvStk28Enum1() != null) {
                    switch (common28InSaveVO.getInvStk28Enum1()) {
                        case T_TYPE_20:
                        case T_TYPE_21:
                        case T_TYPE_22:
                        case T_TYPE_23:
                        case T_TYPE_07_01:
                            BigDecimal qty = common28InSaveVO.getQty() == null ? BigDecimal.ZERO : common28InSaveVO.getQty().abs();
                            BigDecimal avalQty = invStk.getAvalQty() == null ? BigDecimal.ZERO : invStk.getAvalQty();
                            if ((avalQty.subtract(qty)).compareTo(BigDecimal.ZERO) < 0) {
                                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "库存可用量不足");
                            }
                            break;
                    }
                }
                if (common28InSaveVO.getInvStk28Enum2() != null) {
                    switch (common28InSaveVO.getInvStk28Enum2()) {
                        case T_TYPE_20:
                        case T_TYPE_21:
                        case T_TYPE_22:
                        case T_TYPE_23:
                        case T_TYPE_07_01:
                            BigDecimal qty = common28InSaveVO.getQty() == null ? BigDecimal.ZERO : common28InSaveVO.getQty().abs();
                            BigDecimal avalQty = invStk.getAvalQty() == null ? BigDecimal.ZERO : invStk.getAvalQty();
                            if ((avalQty.subtract(qty)).compareTo(BigDecimal.ZERO) < 0) {
                                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "库存可用量不足");
                            }
                            break;
                    }
                }
            }
            ItmItemRpcDTO itmItemVO = itmItemVOS.stream().filter(i -> i.getId().equals(common28InSaveVO.getItemId())).findAny().get();
            InvWhRespVO invWhRespVO = orgWhVOList.stream().filter(i -> i.getId().equals(common28InSaveVO.getWhId())).findAny().get();
            // 同步操作： 保存并插入io 履历
            saveOrUpdate(common28InSaveVO, invStk, itmItemVO, invWhRespVO, ioBatchId);

        });
    }




    /**
     * 新增/更新 库存数量，并记录io明细
     *
     * @param common28InVO
     * @param invStk       库存，没有库存 就新增库存
     * @param itmItemVO
     * @param invWhRespVO
     */
    private void saveOrUpdate(InvStkCommon28InSaveVO common28InVO, InvStkRespVO invStk, ItmItemRpcDTO itmItemVO, InvWhRespVO invWhRespVO, Long ioBatchId) {
        OrgOuRpcDTO orgOuVO = outouService.findOuById(invWhRespVO.getOuId());
        if(orgOuVO == null){
            throw new BusinessException(ApiCode.FAIL, "公司数据异常，请检查！");
        }
        InvStkDO invStkDO = new InvStkDO();
        invStkDO.setOhQty(BigDecimal.ZERO);
        invStkDO.setOhQty2(BigDecimal.ZERO);
        invStkDO.setRsvQty(BigDecimal.ZERO);
        invStkDO.setRsvQty2(BigDecimal.ZERO);
        invStkDO.setRsvQty3(BigDecimal.ZERO);
        invStkDO.setRsvQty4(BigDecimal.ZERO);
        invStkDO.setLockQty(BigDecimal.ZERO);
        invStkDO.setLockQty2(BigDecimal.ZERO);
        invStkDO.setLockQty3(BigDecimal.ZERO);
        invStkDO.setLockQty4(BigDecimal.ZERO);

        invStkDO.setOwQty(BigDecimal.ZERO);
        invStkDO.setOwQty2(BigDecimal.ZERO);
        invStkDO.setOwQty3(BigDecimal.ZERO);
        invStkDO.setOwQty4(BigDecimal.ZERO);
        invStkDO.setAvalQty(BigDecimal.ZERO);
        invStkDO.setAvalQty2(BigDecimal.ZERO);
        invStkDO.setId(invStk.getId());
        /**库存数量操作**/
        setInvStkDOQty(common28InVO.getInvStk28Enum1(), common28InVO.getQty(), invStkDO);
        setInvStkDOQty(common28InVO.getInvStk28Enum2(), common28InVO.getQty(), invStkDO);
        //库存更新
        int result = invStkService.updateStkQty(invStkDO);
        if (result != 1) {
            log.error("共通方法28/37，库存操作失败(库存数量不足)。单据信息：" + common28InVO.toString());
            throw new BusinessException("库存操作失败(库存数量不足)");
        }
        //插入出入库履历
        saveInvIoLog(common28InVO, common28InVO.getInvStk28Enum1(),
                itmItemVO, orgOuVO,ioBatchId, 1D,invWhRespVO);
        saveInvIoLog(common28InVO, common28InVO.getInvStk28Enum2(),
                itmItemVO, orgOuVO, ioBatchId, 2D,invWhRespVO);



    }

    /**
     * 库存操作数量 赋值
     *
     * @param invStk28Enum
     * @param qty
     * @param invStkDO
     */
    private void setInvStkDOQty(InvStk28Enum invStk28Enum, BigDecimal qty, InvStkDO invStkDO) {
        if (invStk28Enum == null) {
            return;
        }

        qty = qty == null ? BigDecimal.ZERO : qty.abs();

        switch (invStk28Enum) {
            case O_TYPE_01_01:
            case O_TYPE_03:
            case O_TYPE_05:
            case O_TYPE_14:
            case O_TYPE_17:
            case O_TYPE_19:
                invStkDO.setOhQty(setQty(invStkDO.getOhQty()).subtract(qty));
                break;
            case I_TYPE_02:
            case I_TYPE_19:
            case I_TYPE_04:
            case I_TYPE_06:
            case I_TYPE_15:
            case I_TYPE_16:
            case I_TYPE_18:
                invStkDO.setOhQty(setQty(invStkDO.getOhQty()).add(qty));
                break;
//            case O_TYPE_01_02:
            case T_TYPE_07_02:
                invStkDO.setRsvQty(setQty(invStkDO.getRsvQty()).subtract(qty));
                break;
            case T_TYPE_07_01:
                invStkDO.setRsvQty(setQty(invStkDO.getRsvQty()).add(qty)); // 预留增
                break;
//            case T_TYPE_07_04:
//            case T_TYPE_11:
//            case T_TYPE_12:
//            case T_TYPE_13:
//                invStkDO.setRsvQty2(setQty(invStkDO.getRsvQty2()).subtract(qty)); //预留减
//                break;
//            case T_TYPE_07_03:
//            case T_TYPE_10:
//                invStkDO.setRsvQty2(setQty(invStkDO.getRsvQty2()).add(qty));
//                break;

            /******************** 库存锁定******************/
            case T_TYPE_20:
            case T_TYPE_21:
            case T_TYPE_22:
            case T_TYPE_23:
                invStkDO.setLockQty(setQty(invStkDO.getLockQty()).add(qty));
                break;
            case T_TYPE_24:
            case T_TYPE_25:
            case T_TYPE_26:
            case T_TYPE_27:
                invStkDO.setLockQty(setQty(invStkDO.getLockQty()).subtract(qty));
                break;
        }
//        log.info("lockQty:{};rsvQty:{};ohQty:{},rsvQty2:{}",invStkDO.getLockQty(),invStkDO.getRsvQty(),invStkDO.getOhQty(),invStkDO.getRsvQty2());
//        BigDecimal avalQty = (invStkDO.getOhQty() == null ? BigDecimal.ZERO : invStkDO.getOhQty())
//                .subtract (invStkDO.getRsvQty() == null ? BigDecimal.ZERO : invStkDO.getRsvQty())
//                .subtract(invStkDO.getRsvQty2() == null ? BigDecimal.ZERO : invStkDO.getRsvQty2())
//                .subtract(invStkDO.getLockQty() == null ? BigDecimal.ZERO : invStkDO.getLockQty());
//        log.info("avaQty:{}",avalQty);
//        invStkDO.setAvalQty(avalQty);
    }

    /**
     * 对 null的qty附 初值 0D
     *
     * @param qty
     * @return
     */
    private BigDecimal setQty(BigDecimal qty) {
        return qty == null ? BigDecimal.ZERO : qty;
    }


    /**
     * 记录IO 日志
     *
     * @param common28InVO
     * @param invStk28Enum
     */
    private void saveInvIoLog(InvStkCommon28InSaveVO common28InVO, InvStk28Enum invStk28Enum,
                              ItmItemRpcDTO itmItemVO, OrgOuRpcDTO ou, Long ioBatchId, Double lineNo, InvWhRespVO invWhRespVO) {
        log.info("共通方法29，时间：" + LocalDateTime.now() + "，入参："
                + "InvStkCommon28InSaveVO:" + (common28InVO == null ? null : common28InVO.toString())
                + "InvStk28Enum:" + (invStk28Enum == null ? null : invStk28Enum.getIoCode())
                + "ItmItemVO:" + (itmItemVO == null ? null : itmItemVO.toString())
                + "OrgOuVO2:" + (ou == null ? null : ou.toString())
                + "IoBatchId:" + ioBatchId
                + "LineNo:" + lineNo
        );

        if (invStk28Enum == null) {
            return;
        }
        List<InvIoDO> ioDOList = new ArrayList<>();

        // 1. 记录 oh_qty、rsv_qty、rsv_qty2、lock_qty、ow_qty等
        InvIoDO invIoDO1 = InvCommonConvert.INSTANCE.invStkCommon28InVOToInvIoDO(common28InVO);
        invIoDO1.setIoBatchId(ioBatchId);
        invIoDO1.setLineNo(lineNo);
        invIoDO1.setDeleteFlag(0);
        invIoDO1.setIoCode(invStk28Enum.getIoCode());
        //库存出入表 IO qty 正负处理
        invIoDO1.setQty(setInvIoQty(invStk28Enum, common28InVO.getQty()));
        invIoDO1.setIoDate(common28InVO.getOpDate());
        invIoDO1.setCreateUserId(common28InVO.getCreateUserId()); //默认单据创建人
        //流水发号
        ArrayList<String> runtimeValues = new ArrayList<>();
        String generateCode = systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_MR.getCode(), runtimeValues);
        invIoDO1.setDocNo(generateCode);
        invIoDO1.setUom(itmItemVO.getUom());
        invIoDO1.setOuId(ou.getId());
        invIoDO1.setBuId(ou.getBuId());
        invIoDO1.setItemCode(itmItemVO.getItemCode());
//        invIoDO1.setItemCateCode(itmItemVO.getItemCateCode());
        invIoDO1.setBrand(itmItemVO.getBrand());
        invIoDO1.setHomeCurr(ou.getOuCurr());
        invIoDO1.setIoStatus(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode()); // 有效 、无效
        invIoDO1.setSrcDocNo(common28InVO.getDocNo());
        //库存合作伙伴保存
        invIoDO1.setPType(common28InVO.getPType());
        invIoDO1.setPCode(common28InVO.getPCode());
        invIoDO1.setSecBuId(invWhRespVO.getSecBuId());
        invIoDO1.setSecOuId(invWhRespVO.getSecOuId());
        //库存移动记录时间
        invIoDO1.setCreateTime(LocalDateTime.now());
        ioDOList.add(invIoDO1);
        invIoService.createBatch(ioDOList);
        log.info("帐卡写入成功，参数为：{}",ioDOList);

    }

    /**
     * 库存出入表 IO qty 正负处理
     *
     * @param invStk28Enum
     * @param qty
     * @return
     */
    private BigDecimal setInvIoQty(InvStk28Enum invStk28Enum, BigDecimal qty) {
        qty = qty == null ? BigDecimal.ZERO : qty.abs();

        switch (invStk28Enum) {
            case O_TYPE_01_01:
            case O_TYPE_03:
            case O_TYPE_05:
            case O_TYPE_14:
            case O_TYPE_17:
            case O_TYPE_19:
//            case O_TYPE_01_02:
            case T_TYPE_07_02:
//            case T_TYPE_07_04:
//            case T_TYPE_11:
//            case T_TYPE_12:
//            case T_TYPE_13:
            case T_TYPE_24:
            case T_TYPE_25:
            case T_TYPE_26:
            case T_TYPE_27:
                qty = BigDecimal.ZERO.subtract(qty);
                break;
        }
        return qty;
    }




}
