package com.elitesland.yst.production.inv.application.service.impl;

import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionParam;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.*;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.domain.convert.invwh.InvWhAreaConvert;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhAreaDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhAreaDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaSettingDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaRpcDTO;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhAreaRepoProc;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhRepoProc;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.AllArgsConstructor;
import lombok.val;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author liuqi
 * @since 2020-07-16 14:07:11
 */
@Service
@AllArgsConstructor
public class InvWhAreaServiceImpl implements InvWhAreaService {

    private final InvWhAreaRepoProc invWhAreaRepoProc;

    private final InvWhRepoProc invWhRepoProc;

    private final InvWhDomainService invWhDomainService;

    private final InvWhAreaDomainService invWhAreaDomainService;

    private final InvWhAreaSettingDomainService invWhAreaSettingDomainService;
    private final SystemService systemService;
    private final OrgOutService orgOutService;


    @Override
    @SysCodeProc
    public PagingVO<InvWhAreaRespVO> search(InvWhAreaParamVO param) {
        JPAQuery<InvWhAreaRespVO> jpaQuery = invWhAreaRepoProc.select(null).where(invWhAreaRepoProc.searchWhere(param));
        invWhAreaRepoProc.openOrderAndLimit(jpaQuery, param, QInvWhAreaDO.invWhAreaDO);
        long dataCount = jpaQuery.fetchCount();
        List<InvWhAreaRespVO> lists = jpaQuery.fetch();
        PagingVO<InvWhAreaRespVO> paging = new PagingVO<>();
        paging.setRecords(lists);
        paging.setTotal(dataCount);
        return paging;
    }

    @Override
    @SysCodeProc
    public PagingVO<InvWhRespVO> searchWh(InvWhParamVO param) {
        JPAQuery<InvWhRespVO> invWhs = invWhRepoProc.select(null).where(invWhRepoProc.searchWhere(param));
        long dataCount = invWhs.fetchCount();
        List<InvWhRespVO> lists = invWhs.fetch();
        invWhRepoProc.openOrderAndLimit(invWhs, param, QInvWhDO.invWhDO);
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(dataCount);
        return paging;
    }

    @Override
    @SysCodeProc
    public List<InvWhRespVO> searchWhByParam(InvWhParamVO param) {
        List<InvWhRespVO> invWhRespVOS = invWhDomainService.searchWhByParam(param);
        return invWhRespVOS;
    }

    @Override
    @SysCodeProc
    public Optional<InvWhAreaRespVO> findIdOne(Long id) {
        JPAQuery<InvWhAreaRespVO> jpaQuery = invWhAreaRepoProc.select(null);
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        jpaQuery.where(jpaQDo.id.eq(id));
        InvWhAreaRespVO vo = jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @Override
    public List<InvWhAreaRespVO> findAllByWhId(List<Long> whIds) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        JPAQuery<InvWhAreaRespVO> where = invWhAreaRepoProc.select(null)
                .where(jpaQDo.whId.in(whIds));


        List<InvWhAreaRespVO> lists = where.fetch();
        return lists;
    }

    @Override
    public List<InvWhAreaRespVO> findWhAreasByParam(InvWhAreaParamVO paramVO) {
        List<InvWhAreaRespVO> invWhAreaRespVOList = invWhAreaDomainService.findWhAreasByParam(paramVO);
        return invWhAreaRespVOList;
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<InvWhAreaSaveVO> list) {
        return invWhAreaDomainService.saveInvWhAreas(list.stream().map(InvWhAreaConvert.INSTANCE::voToDO)
                .collect(Collectors.toList()))
                .stream().map(InvWhAreaDO::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void update(InvWhAreaSaveVO item) {
        Optional<InvWhAreaDO> optional = invWhAreaDomainService.findOneById(item.getId());
        if (optional.isPresent()) {
            invWhAreaDomainService.saveInvWhArea(InvWhAreaConvert.INSTANCE.voToDO(item));
        } else {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + item.getId());
        }
    }

    @Override
    @SysCodeProc
    public List<InvWhAreaRpcDTO> findWhAreaRpcDTOByWhIds(List<Long> whIds) {
        InvWhAreaRpcDtoParam paramRpcDTO = new InvWhAreaRpcDtoParam();
        paramRpcDTO.setWhIds(whIds);
        List<InvWhAreaRpcDTO> whAreaRpcDTOS = invWhAreaRepoProc.selectByParam(paramRpcDTO);
        Map<String, String> pTypeMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_EMP.getModel(), UdcEnum.INV_PARTNER_TYPE_EMP.getCode());
        for(InvWhAreaRpcDTO whAreaRpcDTO :whAreaRpcDTOS){
            if(!StringUtils.isEmpty(whAreaRpcDTO.getPType()) && !StringUtils.isEmpty(whAreaRpcDTO.getPCode()))  {
                InvParentParamVO paramVO = new InvParentParamVO();
                paramVO.setType(whAreaRpcDTO.getPType());
                paramVO.setCode(whAreaRpcDTO.getPCode());
                List<OrgRespVO> vos = orgOutService.findcodeAndName(paramVO);
                if (!CollectionUtils.isEmpty(vos)) {
                    vos.stream().filter(m -> m.getCode().equals(whAreaRpcDTO.getPCode())).findFirst().ifPresent(n -> {
                        whAreaRpcDTO.setPName(n.getName());
                    });
                }
                if(!MapUtils.isEmpty(pTypeMap)){
                    whAreaRpcDTO.setPTypeName(pTypeMap.get(whAreaRpcDTO.getPType()));
                }
            }
        }
        return whAreaRpcDTOS;
    }

    @Override
    public List<SelectOptionVO> listDeter2(SelectOptionParam param) {
        List<SelectOptionVO> selectOptionVOS = invWhAreaRepoProc.listDeter2(param);
        return invWhAreaRepoProc.listDeter2(param);
    }

    @Override
    public List<InvWhAreaRespVO> findBydeter2AndDeter2Type(String deter2, String deter2Type) {
        return invWhAreaRepoProc.findDeter2AndDeter2Type(deter2,deter2Type);
    }
}
