package com.elitesland.yst.production.inv.application.service.stk.impl;

import com.elitesland.yst.production.inv.application.service.stk.InvOptCode;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Tom.su
 * @program yst-inv
 * @description
 * @date 2022/04/25 10:02
 */
@Component
@Slf4j
public class InvStkOptFactory implements ApplicationContextAware {

    public static final  Map<String, InvStkOptService> STK_OPT_SERVICE_HASH_MAP = new HashMap<>();

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        applicationContext.getBeansWithAnnotation(InvOptCode.class).entrySet().iterator().forEachRemaining(entrySet ->{
            try {
                InvOptCode invOptCode = AnnotationUtils.findAnnotation(entrySet.getValue().getClass(), InvOptCode.class);
                STK_OPT_SERVICE_HASH_MAP.put(invOptCode.value().getType(),
                        (InvStkOptService) entrySet.getValue());
            } catch (Exception e) {
                log.error("setApplicationContext error,cause->", e);
            }
        });
    }
}