package com.elitesland.yst.production.inv.application.web.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigWhPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigDtlQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryGroupParamVO;
import com.elitesland.yst.production.inv.dto.invDes.param.InvDespatchRpcParam;
import com.elitesland.yst.production.inv.dto.invDes.resp.InvDespatchRpcDTO;
import com.elitesland.yst.production.inv.dto.invTrn.InvTrnResultRpcDTO;
import com.elitesland.yst.production.inv.dto.invTrn.InvTrnSaveRpcDTO;
import com.elitesland.yst.production.inv.dto.invstk.*;
import com.elitesland.yst.production.inv.dto.invstk.param.InvStkCommonOperateRpcParam;
import com.elitesland.yst.production.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.yst.production.inv.provider.*;
import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Objects;

/**
 * @author jeesie
 *
 */

@RestController
@RequestMapping("/inv/provider/Test")
@Api(value = "库存测试", tags = {"库存测试"})
@AllArgsConstructor
public class InvTestController {

    private final InvStkCommonProvider invStkCommonProvider;

    private final InvTrnProvider invTrnProvider;

    private final InvWhProvider invWhProvider;

    private final InvStkProvider invStkProvider;

    private final InvDespatchProvider invDespatchProvider;


    @PostMapping("/invStkOperate")
    @ApiOperation("库存操作")
    public ApiResult<?> operateStk(@RequestBody InvStkCommonOperateRpcParam param) {
        ApiResult<InvStkCommonResultRpcDto> dtoApiResult = invStkCommonProvider.invStkCommonOperate(param);
        return ApiResult.ok(dtoApiResult);
    }

    @PostMapping("/invTrn/submit")
    @ApiOperation("库存转移保存")
    public ApiResult<?> submit(@RequestBody InvTrnSaveRpcDTO invTrnSaveRpcDTO) {
        ApiResult<InvTrnResultRpcDTO> apiResult = invTrnProvider.submitInvTrn(invTrnSaveRpcDTO);
        return ApiResult.ok(apiResult);
    }

    @GetMapping("/invTrn/check/{id}")
    @ApiOperation("库存转移审核")
    public ApiResult<?> checkInvTrn(@PathVariable Long id) {
        Long masId = invTrnProvider.checkInvTrn(id);
        return ApiResult.ok(masId);
    }

    @GetMapping("/invTrn/confirm/{id}")
    @ApiOperation("库存转移确认")
    public ApiResult<?> confirmInvTrn(@PathVariable Long id) {
        invTrnProvider.confirmInvTrn(id);
        return ApiResult.ok();
    }

    @GetMapping("/invTrn/reConfirm/{id}")
    @ApiOperation("库存转移收货确认")
    public ApiResult<?> reConfirmInvTrn(@PathVariable Long id) {
        invTrnProvider.recvConfirmInvTrn(id);
        return ApiResult.ok();
    }

    @PostMapping("/invwh/find")
    @ApiOperation("仓库查询")
    public ApiResult<?> invWhFind(@RequestBody InvWhRpcDtoParam param) {
        ApiResult<List<InvWhRpcDTO>> listApiResult = invWhProvider.findWhDTOByParam(param);
        return ApiResult.ok(listApiResult);
    }

    @PostMapping("/invstk/search")
    @ApiOperation("库存条件查询")
    public ApiResult<?> searchByParam(@RequestBody InvStkAllRpcDtoParam param) {
        List<InvStkRpcDTO> rpcDtoByParam = invStkProvider.findInvStkRpcDtoByParam(param);
        return ApiResult.ok(rpcDtoByParam);
    }

    @PostMapping("/invStk/searchPaging")
    @ApiOperation("库存查询-库存余额查询")
    public ApiResult<?> searchD(@RequestBody InvStkAllRpcDtoParam param) {
        val ret = invStkProvider.searchPaging(param);
        return ApiResult.ok(ret);
    }

    @PostMapping("/invStk/searchLotPaging")
    @ApiOperation("库存查询-库存批次查询")
    public ApiResult<?> searchLot(@RequestBody InvStkDRpcDtoParam param) {
        val ret = invStkProvider.searchLotPaging(param);
        return ApiResult.ok(ret);
    }

    @PostMapping("/invstk/item")
    @ApiOperation("在库商品库存条件查询")
    public ApiResult<?> searchInvStkItem(@RequestBody InvStkItemRpcDtoParam param) {
        List<ItmInvStkItemRpcDTO> ret = invStkProvider.getItemInvStk(param);
        return ApiResult.ok(ret);
    }

    @PostMapping("/invDes/test")
    @ApiOperation("发运地查询")
    public ApiResult<?> getDesList(@RequestBody InvDespatchRpcParam rpcParam) {
        List<InvDespatchRpcDTO> despatchRpcDTOS = invDespatchProvider.findDespatchRpcByParam(rpcParam);
        return ApiResult.ok(despatchRpcDTOS);
    }




}
