package com.elitesland.yst.production.inv.application.web.controller;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.*;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.service.InvWhTreeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/inv/invWh")
@Api(value = "库存中心", tags = {"仓库管理"})
@AllArgsConstructor
public class InvWhController {

    private final InvWhService invWhService;
    private final InvWhTreeService invWhTreeService;

    /**
     * 分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/search")
    @ApiOperation("仓库管理-分页查询")
    public ApiResult<PagingVO<InvWhAreaRespVO>> search(@RequestBody InvWhAreaParamVO param) {
        val ret = invWhService.searchWhArea(param);
        return ApiResult.ok(ret);
    }

    /**
     * 新增数据
     *
     * @param param 新增数据
     * @return 新增数据情况
     */
    @PostMapping("/createOne")
    @ApiOperation("仓库管理-添加与修改")
    public ApiResult<String> createOne(@RequestBody InvWhSaveVO param) {
        Long id = invWhService.createWh(param);
        return ApiResult.ok(id.toString());
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("/findIdOne/{id}")
    @ApiOperation("仓库管理-详情查看-通过主键查询单条数据")
    public ApiResult<InvWhRespVO> findIdOne(@PathVariable Long id) {
        val vo = invWhService.findWhAreaById(id);
        return vo.isPresent() ? ApiResult.ok(vo.get()) : ApiResult.ok();
    }


    /**
     * 分页查询
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/listWh")
    @ApiOperation("仓库管理-分页查询-前端弹窗组件专用")
    public ApiResult<PagingVO<InvWhAreaRespVO>> listWh(@RequestBody InvWhAreaParamVO param) {
        val ret = invWhService.listWhArea(param);
        return ApiResult.ok(ret);
    }

    /**
     * 通过仓库查询仓库功能区列表
     *
     * @param whId 主键
     * @return 单条数据
     */
    @GetMapping("/listDeter2")
    @ApiOperation("通过仓库查询仓库功能区列表")
    public ApiResult<List<InvWhDeter2RespVO>> findDeter2sByWhId(@RequestParam(required = false) Long whId) {
        val ret = invWhService.findDeter2sByWhId(whId);
        return ApiResult.ok(ret);
    }

    /**
     * 批量删除
     *
     * @param ids 删除数据集合
     */
    @DeleteMapping("/deleteBatch")
    @ApiOperation("批量删除")
    public ApiResult<?> deleteBatch(List<Long> ids) {
        invWhService.deleteBatch(ids);
        return ApiResult.ok();
    }


    /**
     * 树形结构查询
     * @return
     */
    @PostMapping("/searchTree")
    @ApiOperation("仓库管理-完整树形结构查询")
    public ApiResult<List<InvWhRespVO>> searchTree(){
        val result = invWhTreeService.searchTree();
        return ApiResult.ok(result);
    }

    /**
     * 树形-查询仓库下功能区
     * @return
     */
    @PostMapping("/searchArea")
    @ApiOperation("树形-查询仓库下功能区")
    public List<InvWhAreaRespVO> searchArea(InvWhAreaParamVO param){
        val result = invWhTreeService.searchArea(param);
        return result;
    }

    /**
     * 树形结构详情查询
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("/findTreeOne/{id}")
    @ApiOperation("仓库管理-树形结构详情查询")
    public ApiResult<InvWhRespVO> findTreeOne(@PathVariable Long id) {
        val vo = invWhTreeService.findTreeOne(id);
        return vo.isPresent() ? ApiResult.ok(vo.get()) : ApiResult.ok();
    }


    /**
     * 树形结构添加与修改
     * @return
     */
    @PostMapping("/createTreeOne")
    @ApiOperation("仓库管理-完整树形结构添加与修改")
    public ApiResult<String> createTreeOne(@RequestBody InvWhSaveVO param){
        val result = invWhTreeService.createTreeOne(param);
        return ApiResult.ok(result.toString());
    }

    @PutMapping("/enable")
    @ApiOperation("仓库管理-启用/禁用")
    public ApiResult<Boolean> enableWhhConfig(@RequestBody InvWhSaveVO invWhSaveVO) {
        return ApiResult.ok(invWhTreeService.enableWhhConfig(invWhSaveVO));
    }

}
