package com.elitesland.yst.production.inv.domain.entity.invstk;

/**
 * PLN_ITEM_PROP
 * InvItemPropDO
 * 品项计划属性
 * @author liuqi
 * @date   2020/8/3 14:14:41


 */

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 商品库存参数
 */
@Entity
@Table(name = "inv_item_prop")
@org.hibernate.annotations.Table(appliesTo = "inv_item_prop", comment = "商品库存参数")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@Accessors(chain = true)
@ApiModel(value = "INV_ITEM_PROP", description = "品项计划属性")
public class InvItemPropDO extends BaseModel implements Serializable
{

    private static final long serialVersionUID = -7213609522251630282L;
    @ApiModelProperty("公司ID")
    @Column(name="ou_id" , columnDefinition = "bigint default 0  comment '公司ID'")
    Long ouId;

    @ApiModelProperty("品项ID")
    @Column(name="item_id" , columnDefinition = "bigint default 0  comment '品项ID'")
    Long itemId;

    @ApiModelProperty("品项编号")
    @Column(name="item_code" , columnDefinition = "varchar(64)  comment '品项编号'")
    String itemCode;

    @ApiModelProperty("品类")
    @Column(name="item_cate_code" , columnDefinition = "varchar(255)  comment '品类编号'")
    String itemCateCode;


    @ApiModelProperty("共享配置参数")
    @Column(name="share_setting" , columnDefinition = "NUMERIC(20,8) comment '共享配置参数'")
    BigDecimal shareSetting;


    @ApiModelProperty("共享类型")
    @Column(name="share_type" , columnDefinition = "varchar(54)  comment '共享类型'")
    String shareType;

    @ApiModelProperty("仓库ID")
    @Column(name="wh_id" , columnDefinition = "bigint default 0  comment '仓库ID'")
    Long whId;

    @ApiModelProperty("计划员员工ID")
    @Column(name="calc_emp_id" , columnDefinition = "bigint default 0  comment '计划员员工ID'")
    Long calcEmpId;

    @ApiModelProperty("采购员员工ID")
    @Column(name="pur_emp_id" , columnDefinition = "bigint default 0  comment '采购员员工ID'")
    Long purEmpId;

    @ApiModelProperty("默认供应商ID")
    @Column(name="supp_id" , columnDefinition = "bigint default 0  comment '默认供应商ID'")
    Long suppId;

    @ApiModelProperty("存储类型 是否库存品项，[UDC]ITM:STORE_TYPE")
    @Column(name="store_type" , columnDefinition = "varchar(64)  comment '存储类型 是否库存品项，[UDC]ITM:STORE_TYPE'")
    String storeType;

    @ApiModelProperty("品牌 用于“多场所间供需关系”，设在需求分部级")
    @Column(name="brand" , columnDefinition = "varchar(64)  comment '品牌 用于“多场所间供需关系”，设在需求分部级'")
    String brand;

    @ApiModelProperty("补货策略 [UDC]PLN:REPLE_POLICY")
    @Column(name="reple_policy" , columnDefinition = "varchar(64)  comment '补货策略 [UDC]PLN:REPLE_POLICY'")
    String replePolicy;

    @ApiModelProperty("计划频率天数")
    @Column(name="reple_frequency_days" , columnDefinition = "int(64)  comment '计划频率天数'")
    Integer repleFrequencyDays;

    @ApiModelProperty("订单覆盖天数")
    @Column(name="reple_cover_days" , columnDefinition = "int(64)  comment '订单覆盖天数'")
    Integer repleCoverDays;

    @ApiModelProperty("本级提前期天数")
    @Column(name="onelevel_lead_days" , columnDefinition = "int(64)  comment '本级提前期天数'")
    Integer onelevelLeadDays;

    @ApiModelProperty("冻结时界天数")
    @Column(name="accum_lead_days" , columnDefinition = "int(64)  comment '冻结时界天数'")
    Integer accumLeadDays;

    @ApiModelProperty("采购MOQ")
    @Column(name="pur_moq" , columnDefinition = "float(20,8)   comment '采购MOQ'")
    Double purMoq;

    @ApiModelProperty("安全库存量")
    @Column(name="safe_qty" , columnDefinition = "float(20,8)   comment '安全库存量'")
    Double safeQty;

    @ApiModelProperty("出库规则")
    @Column(name="picking_rule" , columnDefinition = "varchar(64)  comment '出库规则'")
    String pickingRule;

    @ApiModelProperty("库存呆滞规则")
    @Column(name="inactive_rule" , columnDefinition = "varchar(64)  comment '库存呆滞规则'")
    String inactiveRule;

    @ApiModelProperty("安全库存天数")
    @Column(name="safe_days" , columnDefinition = "int(64)  comment '安全库存天数'")
    Integer safeDays;

    @ApiModelProperty("最大库存量")
    @Column(name="max_qty" , columnDefinition = "float(20,8)   comment '最大库存量'")
    Double maxQty;

    @ApiModelProperty("最小库存量")
    @Column(name="min_qty" , columnDefinition = "float(20,8)   comment '最小库存量'")
    Double minQty;

    @ApiModelProperty("供应商送货周期")
    @Column(name="delivery_days" , columnDefinition = "int(64)  comment '供应商送货周期(天数)'")
    Integer deliveryDays;

    @ApiModelProperty("货架")
    @Column(name="good_shelve" , columnDefinition = "varchar(64)  comment '货架'")
    String goodShelve;


    @ApiModelProperty("采购默认批量")
    @Column(name="pur_def_qty" , columnDefinition = "float(20,8)   comment '采购默认批量'")
    Double purDefQty;

    @ApiModelProperty("采购经济批量")
    @Column(name="pur_eoq" , columnDefinition = "float(20,8)   comment '采购经济批量'")
    Double purEoq;

    @ApiModelProperty("采购计量单位")
    @Column(name="pur_uom" , columnDefinition = "varchar(10)  comment '采购计量单位'")
    String purUom;

    @ApiModelProperty("订单倍数")
    @Column(name="pur_uom_ratio" , columnDefinition = "float(20,8)   comment '订单倍数'")
    Double purUomRatio;

    @ApiModelProperty("属性状态 [UDC]COM:STATUS_ACTIVEORNO")
    @Column(name="prop_status" , columnDefinition = "varchar(64)  comment '属性状态 [UDC]COM:STATUS_ACTIVEORNO'")
    String propStatus;

    @ApiModelProperty("生效时间")
    @Column(name="valid_from" , columnDefinition = "datetime   comment '生效时间'")
    LocalDateTime validFrom;

    @ApiModelProperty("失效时间")
    @Column(name="valid_to" , columnDefinition = "datetime   comment '失效时间'")
    LocalDateTime validTo;

    @ApiModelProperty("上次计划日期")
    @Column(name="last_date" , columnDefinition = "datetime   comment '上次计划日期'")
    LocalDateTime lastDate;

    @ApiModelProperty("计划执行日期")
    @Column(name="next_date" , columnDefinition = "datetime   comment '计划执行日期'")
    LocalDateTime nextDate;

    @ApiModelProperty("ES1")
    @Column(name="es1" , columnDefinition = "varchar(64)  comment 'ES1'")
    String es1;

    @ApiModelProperty("ES2")
    @Column(name="es2" , columnDefinition = "varchar(64)  comment 'ES2'")
    String es2;

    @ApiModelProperty("ES3")
    @Column(name="es3" , columnDefinition = "varchar(64)  comment 'ES3'")
    String es3;

    @ApiModelProperty("ES4")
    @Column(name="es4" , columnDefinition = "varchar(64)  comment 'ES4'")
    String es4;

    @ApiModelProperty("ES5")
    @Column(name="es5" , columnDefinition = "varchar(64)  comment 'ES5'")
    String es5;

    @ApiModelProperty("EN1")
    @Column(name="en1" , columnDefinition = "float(20,2)   comment 'EN1'")
    Double en1;

    @ApiModelProperty("EN2")
    @Column(name="en2" , columnDefinition = "float(20,2)   comment 'EN2'")
    Double en2;

    @ApiModelProperty("EN3")
    @Column(name="en3" , columnDefinition = "float(20,2)   comment 'EN3'")
    Double en3;

    @ApiModelProperty("典型到货新鲜度")
    @Column(name="default_percent_ratio" , columnDefinition = "float(10,8)   comment '典型到货新鲜度'")
    Float defaultPercentRatio;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvItemPropDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvItemPropDO entity = (InvItemPropDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}

