package com.elitesland.yst.production.inv.domain.entity.ioc;


import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * <p>
 * 功能说明:库存操作码
 * </p >
 *
 * @author yangzhibin
 * @date 2020/7/27
 */
@Entity
@Table(name = "inv_ioc")
@org.hibernate.annotations.Table(appliesTo = "inv_ioc", comment = "库存操作码")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "INV_IOC", description = "库存操作码")
public class InvIocDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -3863295502838107507L;

   /* @ApiModelProperty("公司ID")
    @Column(name="ou_id" , columnDefinition = "bigint(20)  comment '公司ID'")
    Long ouId;*/

    @ApiModelProperty("操作码")
    @Column(name = "io_code", columnDefinition = "varchar(40)  comment '操作码'")
    String ioCode;

    @ApiModelProperty("操作码名称")
    @Column(name = "io_name", columnDefinition = "varchar(40)  comment '操作码名称'")
    String ioName;

    @ApiModelProperty("操作类型 [UDC]INV:IO_TYPE")
    @Column(name = "io_type", columnDefinition = "varchar(40)  comment '操作类型 [UDC]INV:IO_TYPE'")
    String ioType;

    @ApiModelProperty("是否启用，默认为启用 [UDC]INV:ACTIVE_STATUS")
    @Column(name = "status", columnDefinition = "varchar(40) default 'ACTIVE'  comment '是否启用，默认为启用 [UDC]INV:ACTIVE_STATUS'")
    String status;

   /* @ApiModelProperty("出入类型2")
    @Column(name="io_type2" , columnDefinition = "varchar(40)  comment '出入类型2'")
    String ioType2;

    @ApiModelProperty("出入类型3")
    @Column(name="io_type3" , columnDefinition = "varchar(40)  comment '出入类型3'")
    String ioType3;

    @ApiModelProperty("ES1")
    @Column(name="es1" , columnDefinition = "varchar(40)  comment 'ES1'")
    String es1;

    @ApiModelProperty("ES2")
    @Column(name="es2" , columnDefinition = "varchar(40)  comment 'ES2'")
    String es2;

    @ApiModelProperty("ES3")
    @Column(name="es3" , columnDefinition = "varchar(40)  comment 'ES3'")
    String es3;

    @ApiModelProperty("ES4")
    @Column(name="es4" , columnDefinition = "varchar(40)  comment 'ES4'")
    String es4;

    @ApiModelProperty("ES5")
    @Column(name="es5" , columnDefinition = "varchar(40)  comment 'ES5'")
    String es5;

    @ApiModelProperty("出入标记")
    @Column(name="io_flag" , columnDefinition = "varchar(1)  comment '出入标记'")
    String ioFlag;*/

}

