package com.elitesland.yst.production.inv.domain.entity.lot;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/15
 * @Version 1.0
 * @Content:
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InvLot extends BaseModel implements Serializable {
    private static final long serialVersionUID = 5876294497293163859L;

    @ApiModelProperty("公司ID")
    Long ouId;

    @ApiModelProperty("BUID")
    Long buId;

    @ApiModelProperty("品项ID")
    Long itemId;

    @ApiModelProperty("异构ID")
    Long variId;

    @ApiModelProperty("品项编号")
    String itemCode;

    @ApiModelProperty("批次号")
    String lotNo;

    @ApiModelProperty("批次说明")
    String lotDesc;

    @ApiModelProperty("批次状态 允许的出入库类型,0,可以出，1不可以出")
    String lotStatus;

    @ApiModelProperty("批次状态2 备用")
    String lotStatus2;

    @ApiModelProperty("批次状态3 备用")
    String lotStatus3;

    @ApiModelProperty("质量状态")
    String qcStatus;

    @ApiModelProperty("卫检状态")
    String sinStatus;

    @ApiModelProperty("锁定原因")
    String lockReason;

    @ApiModelProperty("已卫检数量")
    BigDecimal sinQty;

    @ApiModelProperty("保质期天数")
    Integer expireDays;

    @ApiModelProperty("生产日期")
    LocalDateTime manuDate;

    @ApiModelProperty("生产批次")
    String menuLotNo;

    @ApiModelProperty("整批号")
    String batchNo;

    @ApiModelProperty("失效日期")
    LocalDateTime expireDate;

    @ApiModelProperty("剩余效期天数 每天自动计算")
    Integer untilExpireDays;

    @ApiModelProperty("新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE")
    String fressType;

    @ApiModelProperty("首次入库日期")
    LocalDateTime firstInDate;

    @ApiModelProperty("最后出库日期")
    LocalDateTime lastOutDate;

    @ApiModelProperty("销售截止日期")
    LocalDateTime maxSaleDate;

    @ApiModelProperty("原产国")
    String menuCountry;

    @ApiModelProperty("产地描述")
    String menuDesc;

    @ApiModelProperty("产地证明编号")
    String menuDocNo;

    @ApiModelProperty("制造商ID")
    Long manuerId;

    @ApiModelProperty("制造商编号")
    String manuerCode;

    @ApiModelProperty("制造商名称")
    String manuerName;

    @ApiModelProperty("供应商ID")
    Long suppId;

    @ApiModelProperty("默认卫检单ID")
    Long sinId;

    @ApiModelProperty("默认卫检单编号")
    String sinNo;

    @ApiModelProperty("卫检日期")
    LocalDateTime sinDate;

    @ApiModelProperty("货主类型 供应商/客户，DCH不用")
    String ownerType;

    @ApiModelProperty("货主ID DCH不用")
    Long ownerId;

    @ApiModelProperty("货主编码 DCH不用")
    String ownerCode;

    @ApiModelProperty("来源单据类别")
    String srcDocCls;

    @ApiModelProperty("来源单据ID")
    Long srcDocId;

    @ApiModelProperty("来源单据编号")
    String srcDocNo;

    @ApiModelProperty("来源单据明细ID")
    Long srcDocDid;

    @ApiModelProperty("采购单ID")
    Long poId;

    @ApiModelProperty("采购单号")
    String poNo;

    @ApiModelProperty("采购单类型")
    String poType;

    @ApiModelProperty("采购单明细ID")
    Long poDId;

    @ApiModelProperty("ES1")
    String es1;

    @ApiModelProperty("ES2")
    String es2;

    @ApiModelProperty("ES3")
    String es3;

    @ApiModelProperty("ES4")
    String es4;

    @ApiModelProperty("ES5")
    String es5;

    @ApiModelProperty("DATE1")
    LocalDateTime date1;

    @ApiModelProperty("DATE2")
    LocalDateTime date2;

    @ApiModelProperty("DATE3")
    LocalDateTime date3;

    @ApiModelProperty("DATE4")
    LocalDateTime date4;

    @ApiModelProperty("DATE5")
    LocalDateTime date5;



}
