package com.elitesland.yst.production.inv.domain.entity.scene;

/**
 * @author Tom.su
 * @program yst-inv
 * @description 库存场景配置
 * @date 2022/04/20 14:28
 */

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "inv_scene_config")
@org.hibernate.annotations.Table(appliesTo = "inv_scene_config", comment = "库存场景配置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "inv_scene_config", description = "库存场景配置")
public class InvSceneConfigDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -4186477882371888523L;

    @ApiModelProperty("库存场景码")
    @Column(name = "scene_code", columnDefinition = "varchar(32)  comment '库存场景码'")
    private String sceneCode;

    @ApiModelProperty("库存场景描述，限定长度200之内")
    @Column(name = "scene_desc", columnDefinition = "varchar(200)  comment '库存场景描述'")
    private String sceneDesc;

    @ApiModelProperty("触发单据类型")
    @Column(name = "opt_doc_type", columnDefinition = "varchar(40)  comment '触发单据类型'")
    private String optDocType;


    @ApiModelProperty("触发单据操作描述")
    @Column(name = "opt_doc_desc", columnDefinition = "varchar(40)  comment '触发单据操作描述'")
    private String optDocDesc;

    @ApiModelProperty("启用状态  Y-是 N-否")
    @Column(name = "is_enable", columnDefinition = "varchar(6)  comment '启用状态'")
    private String isEnable;

}