package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAndAsmDSaveVO;
import com.elitesland.yst.production.inv.domain.convert.InvAsmConvert;
import com.elitesland.yst.production.inv.domain.convert.InvAsmDConvert;
import com.elitesland.yst.production.inv.domain.entity.InvAsm;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDDO;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDO;
import com.elitesland.yst.production.inv.domain.service.InvAsmDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvAsmDTO;
import com.elitesland.yst.production.inv.infr.repo.InvAsmRepo;
import com.elitesland.yst.production.inv.infr.repo.InvAsmRepoProc;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;



@Service("invAsmDomainService")
@AllArgsConstructor
public class InvAsmDomainServiceImpl implements InvAsmDomainService {

    private final InvAsmRepo invAsmRepo;

    @Override
    public Optional<InvAsmDTO> findIdOne(Long id) {
        Optional<InvAsmDTO> asmDOOptional = invAsmRepo.findById(id).map(invAsmDO -> {
            InvAsmDTO invAsmDTO = InvAsmConvert.INSTANCE.doToDto(invAsmDO);
            return invAsmDTO;
        });
        return asmDOOptional;
    }



    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long create(InvAsm invAsm) {
        return invAsmRepo.save(InvAsmConvert.INSTANCE.asmToDo(invAsm)).getId();
    }

    @Override
    public List<Long> updateStatusInBatch(List<Long> ids, String status) {
        return null;
    }

    @Override
    public Long submit(Long id) {
        return null;
    }

    @Override
    @javax.transaction.Transactional
    public void check(Long masId) {
        Optional<InvAsmDO> invAsmDOOptional = invAsmRepo.findById(masId);
        if (invAsmDOOptional.isPresent()) {
            if(invAsmDOOptional.get().getProcInstId() != null ){
                throw new BusinessException(ApiCode.FAIL,"该单据已开启工作流审批");
            }
            //状态改为已审批
            invAsmDOOptional.get().setDocStatus(UdcEnum.INV_ASM_STATUS_APPED.getValueCode());
            invAsmRepo.save(invAsmDOOptional.get());
        } else {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + masId);
        }
    }
}
