package com.elitesland.yst.production.inv.domain.service.impl;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigWhPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigDtlQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigQueryParam;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.domain.convert.despatch.InvDespatchConfigConvert;
import com.elitesland.yst.production.inv.domain.entity.despatch.InvDespatchConfigDO;
import com.elitesland.yst.production.inv.domain.service.InvDespatchConfigDomainService;
import com.elitesland.yst.production.inv.dto.invDes.param.InvDespatchRpcParam;
import com.elitesland.yst.production.inv.dto.invDes.resp.InvDespatchRpcDTO;
import com.elitesland.yst.production.inv.infr.dto.InvDespatchConfigDTO;
import com.elitesland.yst.production.inv.infr.repo.despatch.InvDespatchConfigProc;
import com.elitesland.yst.production.inv.infr.repo.despatch.InvDespatchConfigRepo;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * @author jeesie
 * @description:
 * @datetime 2023年 01月 04日 4:55 下午
 * @version: 1.0
 */
@Slf4j
@Service
@AllArgsConstructor
public class InvDespatchConfigDomainServiceImpl implements InvDespatchConfigDomainService {

    private final InvDespatchConfigProc invDespatchConfigProc;

    private final InvDespatchConfigRepo invDespatchConfigRepo;

    private final OrgOutService orgOutService;
    private final JdbcTemplate jdbcTemplate;

    @Override
    public PagingVO<InvDespatchConfigPageVO> searchPage(InvDespatchConfigQueryParam param) {
        return invDespatchConfigProc.searchPage(param);
    }

    @Override
    public List<InvDespatchConfigPageVO> query(InvDespatchConfigQueryParam queryParam) {
        return invDespatchConfigProc.query(queryParam);
    }

    @Override
    public InvDespatchConfigDTO findIdOne(Long id) {
        InvDespatchConfigDTO invDespatchConfigDTO = null;
        val optional = invDespatchConfigRepo.findById(id);
        if(optional.isPresent()){
            invDespatchConfigDTO = InvDespatchConfigConvert.INSTANCE.doToDto(optional.get());
        }
        return invDespatchConfigDTO;
    }

    @Override
    @Transactional
    public Long saveOrUpdate(InvDespatchConfigDTO despatchConfigDTO) {
        InvDespatchConfigDO despatchConfigDO = InvDespatchConfigConvert.INSTANCE.dtoToDo(despatchConfigDTO);
        return invDespatchConfigRepo.save(despatchConfigDO).getId();
    }

    @Override
    public PagingVO<InvDespatchConfigWhPageVO> searchDespatchWhPage(InvDespatchConfigDtlQueryParam param) {
        return invDespatchConfigProc.searchDespatchWhPage(param);
    }

    @Override
    public PagingVO<InvDespatchConfigWhPageVO> newSearchDespatchWhPage(InvDespatchConfigDtlQueryParam param) {
        return invDespatchConfigProc.newSearchDespatchWhPage(param);
    }

    @Override
    @Transactional(rollbackFor = Exception.class )
    public Boolean enableDespatchConfig(List<Long> ids, String isEnable) {
        try {
            invDespatchConfigProc.enableDespatchConfig(ids, isEnable);
        } catch (Exception e){
            log.error("修改失败："+e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public List<InvDespatchConfigRespVO> getDeter2Count(List<String> desCodes){
        List<Map<String, Object>> mapList = invDespatchConfigRepo.getdeter2Count(desCodes);
        mapList = mapList.stream().filter(i -> i.isEmpty() != true && i.size() > 0).collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(mapList)){
            List<InvDespatchConfigRespVO> invDespatchConfigRespVOS = JSON.parseArray(JSON.toJSONString(mapList), InvDespatchConfigRespVO.class);
            return invDespatchConfigRespVOS;
        }
        return null;
    }

    @Override
    public List<InvDespatchRpcDTO> findDespatchRpcByParam(InvDespatchRpcParam param) {
        return invDespatchConfigProc.findDespatchRpcByParam(param);
    }

    @Override
    public List<InvDespatchRpcDTO> findByDesName(String desName) {
        InvDespatchRpcParam param = new InvDespatchRpcParam();
        param.setDesName(desName);
        return invDespatchConfigProc.findDespatchRpcByParam(param);
    }

    @Override
    public List<InvDespatchRpcDTO> findByDesCode(String desCode) {
        InvDespatchRpcParam param = new InvDespatchRpcParam();
        param.setDesCode(desCode);
        return invDespatchConfigProc.findDespatchRpcByParam(param);
    }

    @Override
    public List<InvDespatchConfigRespVO> findByIdBatch(List<Long> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return new ArrayList<>();
        }
        return invDespatchConfigProc.findDespatchByIdBatch(ids);
    }

    @Override
    public List<InvDespatchRpcDTO> findByDesCodeBatch(List<String> desCodes) {
        if(CollectionUtils.isEmpty(desCodes)){
            return new ArrayList<>();
        }
        InvDespatchRpcParam param = new InvDespatchRpcParam();
        param.setDesCodes(desCodes);
        return invDespatchConfigProc.findDespatchRpcByParam(param);
    }

    @Override
    public List<InvDespatchRpcDTO> findByDesCodeBatch(List<String> desCodes,Long tenantId) {
        if(CollectionUtils.isEmpty(desCodes)){
            return new ArrayList<>();
        }
        //InvDespatchRpcParam param = new InvDespatchRpcParam();
        //param.setDesCodes(desCodes);
        //return invDespatchConfigProc.findDespatchRpcByParam(param,tenantId);
       // return invDespatchConfigRepo.findDespatchRpcByParam(desCodes,tenantId);


            StringBuffer sb = new StringBuffer("SELECT   " +
                    "             id,  " +
                    "             des_code as desCode,  " +
                    "             des_name as desName,  " +
                    "             is_enable as isEnable,  " +
                    "             deter1 as deter1,  " +
                    "             deter3 as deter3,  " +
                    "             deter4 as deter4,  " +
                    "             deter5 as deter5,  " +
                    "             deter6 as deter6,  " +
                    "             trade_company_flag as tradeCompanyFlag    " +
                    "             FROM  inv_despatch_config  " +
                    "             WHERE  (delete_flag = 0 or delete_flag  is null)  " +
                    "                 AND tenant_id = '" + tenantId + "' ");
            sb.append(" and des_code in ('");
            sb.append(String.join("','", desCodes));
            sb.append("')");
            return jdbcTemplate.query(sb.toString(), new BeanPropertyRowMapper<>(InvDespatchRpcDTO.class));

    }

}
