package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnAllQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.domain.convert.InvTrnDConvert;
import com.elitesland.yst.production.inv.domain.entity.invtrn.InvTrnD;
import com.elitesland.yst.production.inv.domain.service.InvTrnDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.entity.InvTrnDDO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnAndTrnDTO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnDDTO;
import com.elitesland.yst.production.inv.infr.repo.InvTrnDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvTrnDRepoProc;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author jeesie.jiang
 * @date 2022-03-17 11:37
 * Desc:
 */
@Slf4j
@Service
@AllArgsConstructor
public class InvTrnDDomainServiceImpl implements InvTrnDDomainService {

    private final InvTrnDRepo invTrnDRepo;

    private final InvTrnDRepoProc invTrnDRepoProc;

    private final SystemService systemService;

    private final InvWhAreaDomainService invWhAreaDomainService;

    @Override
    public PagingVO<InvTrnAndTrnDTO> search(InvTrnAllQueryParamVO param) {
        if(StringUtils.hasText(param.getODeter2KeyWord())){
            if (findByDeter2KeyWord(param)) return PagingVO.<InvTrnAndTrnDTO>builder()
                    .total(0L)
                    .records(new ArrayList<>())
                    .build();
        }
        if(StringUtils.hasText(param.getIDeter2KeyWord())){
            if (findByDeter2KeyWord(param)) return PagingVO.<InvTrnAndTrnDTO>builder()
                    .total(0L)
                    .records(new ArrayList<>())
                    .build();
        }
        val invTrns = invTrnDRepoProc.selectH(param);
        param.fillOrders(invTrns);
        param.setPaging(invTrns);
        val ins = invTrns.fetch();
        // 特殊字段需要重新赋值
        ins.forEach(i -> {
            Optional.of(i.getId()).ifPresent(t -> {
                invTrnDRepo.findById(t).ifPresent(tt -> {
                    i.setODeter1(tt.getODeter1());
                    i.setODeter2(tt.getODeter2());
                    i.setOWhId(tt.getOWhId());
                    i.setOOuId(tt.getOOuId());
                    i.setIDeter1(tt.getIDeter1());
                    i.setIDeter2(tt.getIDeter2());
                    i.setIWhId(tt.getIWhId());
                });
            });
        });
        return PagingVO.<InvTrnAndTrnDTO>builder()
                .total(invTrns.fetchCount())
                .records(ins)
                .build();

    }

    private boolean findByDeter2KeyWord(InvTrnAllQueryParamVO param) {
        List<InvWhAreaRespVO> byDeter2KeyWord = invWhAreaDomainService.findByDeter2KeyWord(param.getODeter2KeyWord());
        if(CollectionUtils.isEmpty(byDeter2KeyWord)){
            return true;
        }
        List<String> iDeter2s = byDeter2KeyWord.stream().map(InvWhAreaRespVO::getDeter2).filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        param.setODeter2s(iDeter2s);
        return false;
    }

    @Override
    public List<InvTrnDDTO> findByMasId(Long trnId) {
        return invTrnDRepo.findByMasId(trnId).stream().map(InvTrnDConvert.INSTANCE::doToTrnDDTO).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> idList) {
        idList.forEach(id -> invTrnDRepo.deleteById(id));
    }

    @Override
    @SysCodeProc
    public List<InvTrnAndTrnDTO> findAll(InvTrnAllQueryParamVO param) {
        val invTrns = invTrnDRepoProc.selectD(param).fetch();
        invTrns.forEach(i -> {
            Optional.of(i.getId()).ifPresent(t -> {
                invTrnDRepo.findById(t).ifPresent(tt -> {
                    i.setODeter1(tt.getODeter1());
                    i.setODeter2(tt.getODeter2());
                    i.setOWhId(tt.getOWhId());
                    i.setOWhCode(tt.getOWhCode());
                    i.setIWhCode(tt.getIWhCode());
                    i.setIDeter1(tt.getIDeter1());
                    i.setIDeter2(tt.getIDeter2());
                    i.setIWhId(tt.getIWhId());
                });
            });
        });
        return invTrns;
    }

    @Override
    @Transactional
    public void createBatch(List<InvTrnD> invTrnDS) {
        List<InvTrnDDO> list = invTrnDS.stream().map(InvTrnDConvert.INSTANCE::invTrnDToDO).collect(Collectors.toList());
        invTrnDRepo.saveAll(list);
    }



}
