package com.elitesland.yst.production.inv.infr.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author lvqf
 * @Date 2021/3/4
 * @Description
 */
@Data
public class InvTrnDDTO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = -9145573057020409497L;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("从功能区code [UDC]INV:FUNC_TYPE")
    private String oDeter2;
    @ApiModelProperty("从功能区")
    private String oDeter2Name;

    @ApiModelProperty("到功能区code [UDC]INV:FUNC_TYPE")
    private String iDeter2;
    @ApiModelProperty("到功能区")
    private String iDeter2Name;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("从仓库库存可用量")
    private BigDecimal avalQty;

    @ApiModelProperty("转移数量2")
    private Float qty2;

    @ApiModelProperty("从仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long oWhId;
    @ApiModelProperty("从仓库code")
    private String oWhCode;
    @ApiModelProperty("从仓库")
    private String oWhName;

    @ApiModelProperty("到仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long iWhId;
    @ApiModelProperty("到仓库code")
    private String iWhCode;
    @ApiModelProperty("到仓库")
    private String iWhName;

    @ApiModelProperty("行号")
    Double lineNo;

    @ApiModelProperty("转移数量")
    private Float qty;

    @ApiModelProperty("单位")
    @SysCode(sys = "COM", mod = "UOM")
    private String uom;
    private String uomName;


    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty("品牌编码")
    private String brandCode;

    @ApiModelProperty("包装规格")
    private String packageSpec;

    @ApiModelProperty("从库存合作伙伴编码")
    String oPCode;

    @ApiModelProperty("至库存合作伙伴编码")
    String iPCode;

    @ApiModelProperty("库存合作伙伴类型")
    String oPType;

    @ApiModelProperty("库存合作伙伴类型")
    String oPName;

    @ApiModelProperty("库存合作伙伴类型")
    String iPName;

    @ApiModelProperty("库存合作伙伴类型名")
    String oPTypeName;

    @ApiModelProperty("库存合作伙伴类型名")
    String iPTypeName;

    @ApiModelProperty("库存合作伙伴类型")
    String iPType;

    @ApiModelProperty("是否启用批次号: true：是，false：否")
    private Boolean lotFlag;



}
