package com.elitesland.yst.production.inv.infr.repo.carr;


import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrDParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrDRespVO;
import com.elitesland.yst.production.inv.domain.entity.carr.QInvCarrDDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * @author feng
 * @program: yst-inv
 * @description: 承运商配送单明细
 * @date 2021-09-19 11:31:49
 */
@Component
@RequiredArgsConstructor
public class InvCarrDRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    public JPAQuery<InvCarrDRespVO> select(InvCarrDParamVO param) {
        val jpaQDo = QInvCarrDDO.invCarrDDO;
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvCarrDRespVO.class,

                jpaQDo.id,
                jpaQDo.masId,
                jpaQDo.lineNo,
                jpaQDo.poDId,
                jpaQDo.itemId,
                jpaQDo.variId,
                jpaQDo.whId,
                jpaQDo.deter1,
                jpaQDo.deter2,
                jpaQDo.deter3,
                jpaQDo.deter4,
                jpaQDo.deter5,
                jpaQDo.deter6,
                jpaQDo.deter7,
                jpaQDo.deter8,
                jpaQDo.whLoc,
                jpaQDo.acceptQty,
                jpaQDo.whPosi,
                jpaQDo.qty,
                jpaQDo.uom,
                jpaQDo.qty2,
                jpaQDo.uom2,
                jpaQDo.uomRatio,
                jpaQDo.uomRatio2,
                jpaQDo.lotNo,
                jpaQDo.menuLotNo,
                jpaQDo.manuDate,
                jpaQDo.expireDate,
                jpaQDo.expireDays,
                jpaQDo.untilExpireDays,
                jpaQDo.demandFreshPercent,
                jpaQDo.demandAapDays,
                jpaQDo.etaAapDays,
                jpaQDo.isFressValid,
                jpaQDo.actualFreshPercent,
                jpaQDo.barcode,
                jpaQDo.rootId,
                jpaQDo.relateDocCls,
                jpaQDo.relateDocType,
                jpaQDo.relateDocId,
                jpaQDo.relateDocNo,
                jpaQDo.relateDocDid,
                jpaQDo.relateDocLineno,
                jpaQDo.relateDoc2Cls,
                jpaQDo.relateDoc2Type,
                jpaQDo.relateDoc2Id,
                jpaQDo.relateDoc2No,
                jpaQDo.relateDoc2Did,
                jpaQDo.relateDoc2Lineno,
                jpaQDo.rootDocId,
                jpaQDo.rootDocNo,
                jpaQDo.rootDocCls,
                jpaQDo.rootDocDid,
                jpaQDo.rootDocLineno,
                jpaQDo.rootDocType,
                jpaQDo.outerId,
                jpaQDo.outerType,
                jpaQDo.outerNo,
                jpaQDo.outerDid,
                jpaQDo.outerLineno,
                jpaQDo.es1,
                jpaQDo.es2,
                jpaQDo.es3,
                jpaQDo.es4,
                jpaQDo.es5,
                jpaQDo.dbrand,
                jpaQDo.tenantId,
                jpaQDo.remark,
                jpaQDo.createUserId,
                jpaQDo.createTime,
                jpaQDo.modifyUserId,
                jpaQDo.modifyTime,
                jpaQDo.deleteFlag,
                jpaQDo.auditDataVersion,
                jpaQDo.basePrice,
                jpaQDo.priceType,
                jpaQDo.netPrice,
                jpaQDo.price,
                jpaQDo.pbPrice,
                jpaQDo.pbCurr,
                jpaQDo.pbUom,
                jpaQDo.discType,
                jpaQDo.discRatio,
                jpaQDo.discAmt,
                jpaQDo.discDesc,
                jpaQDo.discedPrice,
                jpaQDo.taxCode,
                jpaQDo.taxRateNo,
                jpaQDo.taxRate,
                jpaQDo.currNetPrice,
                jpaQDo.currPrice,
                jpaQDo.homeCurr,
                jpaQDo.currCode,
                jpaQDo.currRate,
                jpaQDo.taxAmt,
                jpaQDo.amt,
                jpaQDo.netAmt,
                jpaQDo.currAmt,
                jpaQDo.currNetAmt


        )).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    public Predicate where(InvCarrDParamVO param) {
        val jpaQDo = QInvCarrDDO.invCarrDDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
        }
        if (!StringUtils.isEmpty(param.getMasId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.masId.eq(param.getMasId()));
        }
        if (!StringUtils.isEmpty(param.getLineNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lineNo.eq(param.getLineNo()));
        }
        if (!StringUtils.isEmpty(param.getPoDId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.poDId.eq(param.getPoDId()));
        }
        if (!StringUtils.isEmpty(param.getItemId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemId.eq(param.getItemId()));
        }
        if (!StringUtils.isEmpty(param.getVariId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.variId.eq(param.getVariId()));
        }
        if (!StringUtils.isEmpty(param.getWhId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.eq(param.getWhId()));
        }
        if (!StringUtils.isEmpty(param.getDeter1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter1.eq(param.getDeter1()));
        }
        if (!StringUtils.isEmpty(param.getDeter2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.eq(param.getDeter2()));
        }
        if (!StringUtils.isEmpty(param.getDeter3())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter3.eq(param.getDeter3()));
        }
        if (!StringUtils.isEmpty(param.getDeter4())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter4.eq(param.getDeter4()));
        }
        if (!StringUtils.isEmpty(param.getDeter5())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter5.eq(param.getDeter5()));
        }
        if (!StringUtils.isEmpty(param.getDeter6())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter6.eq(param.getDeter6()));
        }
        if (!StringUtils.isEmpty(param.getDeter7())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter7.eq(param.getDeter7()));
        }
        if (!StringUtils.isEmpty(param.getDeter8())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter8.eq(param.getDeter8()));
        }
        if (!StringUtils.isEmpty(param.getWhLoc())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whLoc.eq(param.getWhLoc()));
        }
        if (!StringUtils.isEmpty(param.getWhPosi())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whPosi.eq(param.getWhPosi()));
        }
        if (!StringUtils.isEmpty(param.getQty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.qty.eq(param.getQty()));
        }
        if (!StringUtils.isEmpty(param.getUom())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.uom.eq(param.getUom()));
        }
        if (!StringUtils.isEmpty(param.getQty2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.qty2.eq(param.getQty2()));
        }
        if (!StringUtils.isEmpty(param.getUom2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.uom2.eq(param.getUom2()));
        }
        if (!StringUtils.isEmpty(param.getUomRatio())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.uomRatio.eq(param.getUomRatio()));
        }
        if (!StringUtils.isEmpty(param.getUomRatio2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.uomRatio2.eq(param.getUomRatio2()));
        }
        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lotNo.eq(param.getLotNo()));
        }
        if (!StringUtils.isEmpty(param.getMenuLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.menuLotNo.eq(param.getMenuLotNo()));
        }
        if (!StringUtils.isEmpty(param.getManuDate())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.manuDate.eq(param.getManuDate()));
        }
        if (!StringUtils.isEmpty(param.getExpireDate())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.expireDate.eq(param.getExpireDate()));
        }
        if (!StringUtils.isEmpty(param.getExpireDays())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.expireDays.eq(param.getExpireDays()));
        }
        if (!StringUtils.isEmpty(param.getUntilExpireDays())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.untilExpireDays.eq(param.getUntilExpireDays()));
        }
        if (!StringUtils.isEmpty(param.getDemandFreshPercent())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.demandFreshPercent.eq(param.getDemandFreshPercent()));
        }
        if (!StringUtils.isEmpty(param.getDemandAapDays())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.demandAapDays.eq(param.getDemandAapDays()));
        }
        if (!StringUtils.isEmpty(param.getEtaAapDays())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.etaAapDays.eq(param.getEtaAapDays()));
        }
        if (!StringUtils.isEmpty(param.getIsFressValid())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.isFressValid.eq(param.getIsFressValid()));
        }
        if (!StringUtils.isEmpty(param.getBarcode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.barcode.eq(param.getBarcode()));
        }
        if (!StringUtils.isEmpty(param.getRootId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.rootId.eq(param.getRootId()));
        }
        if (!StringUtils.isEmpty(param.getRelateDocCls())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDocCls.eq(param.getRelateDocCls()));
        }
        if (!StringUtils.isEmpty(param.getRelateDocType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDocType.eq(param.getRelateDocType()));
        }
        if (!StringUtils.isEmpty(param.getRelateDocId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDocId.eq(param.getRelateDocId()));
        }
        if (!StringUtils.isEmpty(param.getRelateDocNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDocNo.eq(param.getRelateDocNo()));
        }
        if (!StringUtils.isEmpty(param.getRelateDocDid())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDocDid.eq(param.getRelateDocDid()));
        }
        if (!StringUtils.isEmpty(param.getRelateDocLineno())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDocLineno.eq(param.getRelateDocLineno()));
        }
        if (!StringUtils.isEmpty(param.getRelateDoc2Cls())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDoc2Cls.eq(param.getRelateDoc2Cls()));
        }
        if (!StringUtils.isEmpty(param.getRelateDoc2Type())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDoc2Type.eq(param.getRelateDoc2Type()));
        }
        if (!StringUtils.isEmpty(param.getRelateDoc2Id())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDoc2Id.eq(param.getRelateDoc2Id()));
        }
        if (!StringUtils.isEmpty(param.getRelateDoc2No())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDoc2No.eq(param.getRelateDoc2No()));
        }
        if (!StringUtils.isEmpty(param.getRelateDoc2Did())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDoc2Did.eq(param.getRelateDoc2Did()));
        }
        if (!StringUtils.isEmpty(param.getRelateDoc2Lineno())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDoc2Lineno.eq(param.getRelateDoc2Lineno()));
        }
        if (!StringUtils.isEmpty(param.getEs1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es1.eq(param.getEs1()));
        }
        if (!StringUtils.isEmpty(param.getEs2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es2.eq(param.getEs2()));
        }
        if (!StringUtils.isEmpty(param.getEs3())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es3.eq(param.getEs3()));
        }
        if (!StringUtils.isEmpty(param.getEs4())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es4.eq(param.getEs4()));
        }
        if (!StringUtils.isEmpty(param.getEs5())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es5.eq(param.getEs5()));
        }
        if (!StringUtils.isEmpty(param.getTenantId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.tenantId.eq(param.getTenantId()));
        }
        if (!StringUtils.isEmpty(param.getRemark())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.remark.eq(param.getRemark()));
        }
        if (!StringUtils.isEmpty(param.getCreateUserId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.createUserId.eq(param.getCreateUserId()));
        }
        if (!StringUtils.isEmpty(param.getCreateTime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.createTime.eq(param.getCreateTime()));
        }
        if (!StringUtils.isEmpty(param.getModifyUserId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.modifyUserId.eq(param.getModifyUserId()));
        }
        if (!StringUtils.isEmpty(param.getModifyTime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.modifyTime.eq(param.getModifyTime()));
        }
        if (!StringUtils.isEmpty(param.getDeleteFlag())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deleteFlag.eq(param.getDeleteFlag()));
        }
        if (!StringUtils.isEmpty(param.getAuditDataVersion())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.auditDataVersion.eq(param.getAuditDataVersion()));
        }
        return predicate;
    }
}
