package com.elitesland.yst.production.inv.infr.repo.invwh;

import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionParam;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRpcDtoParam;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeter2RespVO;
import com.elitesland.yst.production.inv.domain.entity.despatch.QInvDespatchConfigDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhAreaDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.domain.entity.whAreaSetting.QInvWhAreaSettingDO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaRpcDTO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.querydsl.core.group.GroupBy.groupBy;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author liuqi
 * @since 2020-07-16 14:07:12
 */
@Component
@AllArgsConstructor
public class InvWhAreaRepoProc implements JpaQueryProcInterface {

    private final JPAQueryFactory jpaQueryFactory;

    private final QInvWhAreaSettingDO areaSettingDO = QInvWhAreaSettingDO.invWhAreaSettingDO;

    private final QInvWhDO whDO = QInvWhDO.invWhDO;

    /**
     * 查询字段
     */
    public JPAQuery<InvWhAreaRespVO> select(InvWhAreaParamVO param) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhAreaRespVO.class,
                jpaQDo.id,
                jpaQDo.buId,
                jpaQDo.addrNo,
                jpaQDo.deter2Type,
                jpaQDo.deter2Name,
                jpaQDo.secBuId,
                jpaQDo.secUserId,
                jpaQDo.secOuId,
                jpaQDo.whId,
                jpaQDo.whArea,
                jpaQDo.deter2,
                jpaQDo.deter2Type,
                jpaQDo.deter2Name,
                jpaQDo.deter2Status,
                jpaQDo.pCode.as("PCode"),
                jpaQDo.pType.as("PType"),
                jpaQDo.pAddr.as("PAddr"),
                jpaQDo.deter3,
                jpaQDo.deter1,
                jpaQDo.deter8,
                jpaQDo.outerCode,
                jpaQDo.outerCodeName,
                jpaQDo.outerCode2,
                jpaQDo.es1,
                jpaQDo.es2,
                jpaQDo.es3,
                jpaQDo.tenantId,
                jpaQDo.remark,
                jpaQDo.createUserId,
                jpaQDo.createTime,
                jpaQDo.modifyUserId,
                jpaQDo.modifyTime,
                jpaQDo.deleteFlag,
                jpaQDo.auditDataVersion,
                jpaQDo.jdsybCode,
                jpaQDo.jdsybCodeName,
                jpaQDo.country,
                jpaQDo.province,
                jpaQDo.city,
                jpaQDo.county,
                jpaQDo.detailaddr,
                jpaQDo.otherSysCode,
                jpaQDo.otherSysName
           )).from(jpaQDo);
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        if (param !=null){
            jpaQuery.where(where(param));
        }
        return jpaQuery;
    }


    public List<InvWhAreaRespVO> selectByDeter2Names(List<String> deter2Names) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhAreaRespVO.class,
                jpaQDo.id,
                jpaQDo.deter2Type,
                jpaQDo.deter2Name,
                jpaQDo.deter2,
                jpaQDo.whId
        )).from(jpaQDo);
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(jpaQDo.deter2Name.in(deter2Names));
        predicates.add(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    public List<InvWhAreaRespVO> findByDeter2KeyWord(String deter2KeyWord){
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhAreaRespVO.class,
                jpaQDo.id,
                jpaQDo.deter2Type,
                jpaQDo.deter2Name,
                jpaQDo.deter2,
                jpaQDo.whId
        )).from(jpaQDo);
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(ExpressionUtils.or(
                jpaQDo.deter2.like("%" + deter2KeyWord + "%"),
                jpaQDo.deter2Name.like("%" + deter2KeyWord + "%")
        ));
        predicates.add(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }


    /**
     * 查询字段
     */
    public PagingVO<InvWhAreaRespVO> selectWhAreaPaging(InvWhAreaParamVO param) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        val areaSettingDO = QInvWhAreaSettingDO.invWhAreaSettingDO;
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhAreaRespVO.class,
                jpaQDo.id,
                jpaQDo.buId,
                jpaQDo.whId,
                jpaQDo.secBuId,
                jpaQDo.secUserId,
                jpaQDo.secOuId,
                jpaQDo.whArea,
                jpaQDo.deter2,
                jpaQDo.deter2Type,
                jpaQDo.deter2Name,
                jpaQDo.deter2Status,
                jpaQDo.pCode.as("PCode"),
                jpaQDo.pType.as("PType"),
                jpaQDo.pAddr.as("PAddr"),
                jpaQDo.deter3,
                jpaQDo.deter1,
                jpaQDo.outerCode,
                jpaQDo.outerCodeName,
                jpaQDo.outerCode2,
                jpaQDo.es1,
                jpaQDo.es2,
                jpaQDo.es3,
                jpaQDo.tenantId,
                jpaQDo.remark,
                jpaQDo.createUserId,
                jpaQDo.createTime,
                jpaQDo.modifyUserId,
                jpaQDo.modifyTime,
                jpaQDo.deleteFlag,
                jpaQDo.auditDataVersion,
                jpaQDo.jdsybCodeName,
                jpaQDo.jdsybCode,
                areaSettingDO.businessChoose,
                areaSettingDO.isZeroWh
        )).from(jpaQDo)
                .leftJoin(areaSettingDO)
                .on(jpaQDo.deter2Type.eq(areaSettingDO.deter2Type))
                .where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        if (param !=null){
            jpaQuery.where(where(param));
        }
        long count = jpaQuery.fetchCount();
        openOrderAndLimit(jpaQuery, param, QInvWhAreaDO.invWhAreaDO);
        PagingVO<InvWhAreaRespVO> paging = new PagingVO<>();
        paging.setRecords(jpaQuery.fetch());
        paging.setTotal(count);
        return paging;
    }



    /**
     * 查询字段
     * @param param
     */
    public List<InvWhAreaRpcDTO> selectByParam(InvWhAreaRpcDtoParam param) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        val invWhAreaSettingDO = QInvWhAreaSettingDO.invWhAreaSettingDO;
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhAreaRpcDTO.class,
                jpaQDo.id,
                jpaQDo.whId,
                jpaQDo.buId,
                jpaQDo.secBuId,
                jpaQDo.deter2,
                jpaQDo.deter2Name,
                jpaQDo.deter2Type,
                jpaQDo.addrNo,
                jpaQDo.city,
                jpaQDo.province,
                jpaQDo.country,
                jpaQDo.detailaddr,
                invWhAreaSettingDO.deter2TypeName,
                jpaQDo.pCode.as("PCode"),
                jpaQDo.pType.as("PType"),
                jpaQDo.pAddr.as("PAddr"),
                jpaQDo.jdsybCodeName,
                jpaQDo.jdsybCode
        )).from(jpaQDo).leftJoin(invWhAreaSettingDO)
                .on(jpaQDo.deter2Type.eq(QInvWhAreaSettingDO.invWhAreaSettingDO.deter2Type));
        if (param !=null){
            jpaQuery.where(whereByRpcDtoParam(param));
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery.fetch();
    }


    /**
     * 查询字段
     */
    public List<InvWhAreaRpcDTO> findWhAreaRpcDTO(InvWhAreaParamVO param) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhAreaRpcDTO.class,
                jpaQDo.id,
                jpaQDo.whId,
                jpaQDo.buId,
                jpaQDo.secBuId,
                jpaQDo.whArea,
                jpaQDo.deter2,
                jpaQDo.pCode.as("PCode"),
                jpaQDo.pType.as("PType"),
                jpaQDo.pAddr.as("PAddr"),
                jpaQDo.deter3,
                jpaQDo.deter4,
                jpaQDo.deter1,
                jpaQDo.deter5,
                jpaQDo.deter6,
                jpaQDo.deter7,
                jpaQDo.deter8,
                jpaQDo.outerCode,
                jpaQDo.outerCodeName,
                jpaQDo.outerCode2,
                jpaQDo.jdsybCodeName,
                jpaQDo.jdsybCode,
                jpaQDo.es1,
                jpaQDo.es2,
                jpaQDo.es3,
                jpaQDo.es4,
                jpaQDo.es5,
                jpaQDo.tenantId,
                jpaQDo.remark,
                jpaQDo.createUserId,
                jpaQDo.createTime,
                jpaQDo.modifyUserId,
                jpaQDo.modifyTime,
                jpaQDo.deleteFlag,
                jpaQDo.auditDataVersion
        )).from(jpaQDo);
        if (param !=null){
            jpaQuery.where(where(param));
        }
        return jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()))
                .fetch();
    }

    public Predicate searchWhere(InvWhAreaParamVO param) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull();
        try {
            Predicate predicateAuth = DataAuthJpaUtil.dataAuthJpaPredicate(jpaQDo.getMetadata());
            predicate = ExpressionUtils.and(predicate, predicateAuth);
        } catch (Exception e) {
            throw new BusinessException( ApiCode.FAIL, "数据权限异常");
        }
        if (!CollectionUtils.isEmpty(param.getWhIds())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.in(param.getWhIds()));
        }
        if(!StringUtils.isEmpty(param.getIsFliter()) && param.getIsFliter()){
            predicate = ExpressionUtils.and(predicate, areaSettingDO.businessChoose.eq(false));
            //predicate = ExpressionUtils.and(predicate, areaSettingDO.businessChoose.eq(InvUdcEnum.INV_BUSINESS_CHOOSE_N.getValueCode()));
        }
        if (!StringUtils.isEmpty(param.getDeter2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.eq(param.getDeter2()));
        }
        if (!CollectionUtils.isEmpty(param.getDeter2s())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.in(param.getDeter2s()));
        }

        if (StringUtils.hasLength(param.getDeter2KeyWord())) {
            predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(
                    jpaQDo.deter2.like("%" + param.getDeter2KeyWord() + "%"),
                    jpaQDo.deter2Name.like("%" + param.getDeter2KeyWord() + "%")
            ));
        }
        if (!StringUtils.isEmpty(param.getOuterCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.outerCode.eq(param.getOuterCode()));
        }
        if (!StringUtils.isEmpty(param.getPType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.pType.eq(param.getPType()));
        }
        if (!StringUtils.isEmpty(param.getPptype())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.pType.eq(param.getPptype()));
        }
        if (!StringUtils.isEmpty(param.getPCode())) {
           // predicate = ExpressionUtils.and(predicate, jpaQDo.pCode.eq(param.getPCode()));
            predicate = ExpressionUtils.and(predicate, jpaQDo.pCode.like("%" + param.getPCode() + "%"));

        }
        /** 关键字为拼接查询条件处理 */
        return predicate;
    }


    public Predicate searchWhere2(InvWhAreaParamVO param) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull();
        if (!CollectionUtils.isEmpty(param.getWhIds())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.in(param.getWhIds()));
        }
        if(!StringUtils.isEmpty(param.getIsFliter()) && param.getIsFliter()){
            predicate = ExpressionUtils.and(predicate, areaSettingDO.businessChoose.eq(false));
            //predicate = ExpressionUtils.and(predicate, areaSettingDO.businessChoose.eq(InvUdcEnum.INV_BUSINESS_CHOOSE_N.getValueCode()));

        }
        if (!StringUtils.isEmpty(param.getDeter2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.eq(param.getDeter2()));
        }
        if (!StringUtils.isEmpty(param.getOuterCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.outerCode.eq(param.getOuterCode()));
        }
        if (!StringUtils.isEmpty(param.getPType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.pType.eq(param.getPType()));
        }
        if (!StringUtils.isEmpty(param.getPptype())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.pType.eq(param.getPptype()));
        }
        if (!StringUtils.isEmpty(param.getPCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.pCode.eq(param.getPCode()));
        }
        /** 关键字为拼接查询条件处理 */
        return predicate;
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     */
    public Predicate where(Long id) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
        return predicate;
    }


    /**
     * 条件查询
     * @param param 查询条件
     */
    public Predicate whereByRpcDtoParam(InvWhAreaRpcDtoParam param) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        if (!StringUtils.isEmpty(param.getId() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
        }
        if (StringUtils.hasLength(param.getDeter2Type() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2Type.eq(param.getDeter2Type()));
        }
        if (!StringUtils.isEmpty(param.getWhId() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.eq(param.getWhId()));
        }
        if (!StringUtils.isEmpty(param.getDeter2() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.eq(param.getDeter2()));
        }
        if (!StringUtils.isEmpty(param.getPCode())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.pCode.eq(param.getPCode()));
        }
        if (!StringUtils.isEmpty(param.getPType())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.pType.eq(param.getPType()));
        }

        if (!StringUtils.isEmpty(param.getOuterCode() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.outerCode.eq(param.getOuterCode()));
        }

        if (!StringUtils.isEmpty(param.getCreateUserId() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.createUserId.eq(param.getCreateUserId()));
        }
        if (!StringUtils.isEmpty(param.getCreateTime() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.createTime.eq(param.getCreateTime()));
        }
        if (!StringUtils.isEmpty(param.getModifyUserId() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.modifyUserId.eq(param.getModifyUserId()));
        }
        if (!StringUtils.isEmpty(param.getModifyTime() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.modifyTime.eq(param.getModifyTime()));
        }
        if (!StringUtils.isEmpty(param.getDeleteFlag() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.deleteFlag.eq(param.getDeleteFlag()));
        }
        if (!StringUtils.isEmpty(param.getAuditDataVersion() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.auditDataVersion.eq(param.getAuditDataVersion()));
        }
        if (!CollectionUtils.isEmpty(param.getWhIds() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.in(param.getWhIds()));

        }

        if (!CollectionUtils.isEmpty(param.getDeter2s() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.in(param.getDeter2s()));

        }

        if (!CollectionUtils.isEmpty(param.getDeter2Types() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2Type.in(param.getDeter2Types()));

        }



        return predicate;
    }




    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(InvWhAreaParamVO param) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;

        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        if (!StringUtils.isEmpty(param.getId() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
        }
        if(!StringUtils.isEmpty(param.getIsFliter()) && param.getIsFliter()){
            predicate = ExpressionUtils.and(predicate, areaSettingDO.businessChoose.eq(true));
            //predicate = ExpressionUtils.and(predicate, areaSettingDO.businessChoose.eq(InvUdcEnum.INV_BUSINESS_CHOOSE_Y.getValueCode()));

        }
        if (Objects.nonNull(param.getWhId())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.eq(param.getWhId()));
        }
        if (!CollectionUtils.isEmpty(param.getWhIds() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.in(param.getWhIds()));
        }
        if (StringUtils.hasLength(param.getDeter2() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.eq(param.getDeter2()));
        }
        if(!CollectionUtils.isEmpty(param.getDeter2s())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.in(param.getDeter2s()));
        }
        if (!StringUtils.isEmpty(param.getPCode())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.pCode.eq(param.getPCode()));
        }
        if (!CollectionUtils.isEmpty(param.getPCodes())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.pCode.in(param.getPCodes()));
        }
        if (!StringUtils.isEmpty(param.getPType())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.pType.eq(param.getPType()));
        }

        if (!StringUtils.isEmpty(param.getOuterCode() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.outerCode.eq(param.getOuterCode()));
        }

        if (!StringUtils.isEmpty(param.getCreateUserId() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.createUserId.eq(param.getCreateUserId()));
        }
        if (!StringUtils.isEmpty(param.getCreateTime() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.createTime.eq(param.getCreateTime()));
        }
        if (!StringUtils.isEmpty(param.getModifyUserId() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.modifyUserId.eq(param.getModifyUserId()));
        }
        if (!StringUtils.isEmpty(param.getModifyTime() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.modifyTime.eq(param.getModifyTime()));
        }
        if (!StringUtils.isEmpty(param.getDeleteFlag() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.deleteFlag.eq(param.getDeleteFlag()));
        }
        if (!StringUtils.isEmpty(param.getAuditDataVersion() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.auditDataVersion.eq(param.getAuditDataVersion()));
        }
        return predicate;
    }

    public Predicate deterWhere(Long oWhId, String whArea, String oDeter3) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        if (!StringUtils.isEmpty(oWhId)) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.eq(oWhId));
        }
        if (!StringUtils.isEmpty(whArea)) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whArea.eq(whArea));
        } else {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whArea.eq("").or(jpaQDo.whArea.isNull()));
        }
        if (!StringUtils.isEmpty(oDeter3)) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter3.eq(oDeter3));
        } else {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter3.eq("").or(jpaQDo.deter3.isNull()));
        }

        return predicate;
    }

    public Predicate deter1Where(Long whId, String whArea) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        if(!StringUtils.isEmpty(whId)) {
            predicate = ExpressionUtils.and(predicate,jpaQDo.whId.eq(whId));
        }
        if(!StringUtils.isEmpty(whArea)) {
            predicate = ExpressionUtils.and(predicate,jpaQDo.whArea.eq(whArea));
        }

        return predicate;
    }

    public Predicate deter2Where(InvWhAreaParamVO param){
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        if (!StringUtils.isEmpty(param.getOuterCode() )){
            predicate = ExpressionUtils.and(predicate, jpaQDo.outerCode.eq(param.getOuterCode()));
        }
        if (!StringUtils.isEmpty(param.getMultiKeywords())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whArea.like("%" + param.getMultiKeywords()+ "%"));
        }
        return predicate;
    }

    public List<SelectOptionVO> listDeter2(SelectOptionParam param){
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        JPAQuery<SelectOptionVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                SelectOptionVO.class,
                jpaQDo.id,
                jpaQDo.deter2Name.as("value"),
                jpaQDo.deter2.as("code")
                )
        ).from(jpaQDo).leftJoin(invWhDO).on(jpaQDo.whId.eq(invWhDO.id));
        if(Objects.nonNull(param)){
           jpaQuery.where(whereSelect(param));
        }
        jpaQuery.groupBy(jpaQDo.deter2);
        return jpaQuery.fetch();
    }


    public List<InvWhAreaRespVO> findDeter2AndDeter2Type(String deter2,String deter2Type){
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        JPAQuery<InvWhAreaRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                InvWhAreaRespVO.class,
                jpaQDo.id,
                jpaQDo.deter2Type,
                jpaQDo.deter2
                )
        ).from(jpaQDo);
        jpaQuery.where(jpaQDo.deter2.eq(deter2).and(jpaQDo.deter2Type.eq(deter2Type)));
        return jpaQuery.fetch();
    }


    public Predicate whereSelect(SelectOptionParam param) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull();
        if (StringUtils.hasLength(param.getCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.eq(param.getCode()));
        }
        if (StringUtils.hasLength(param.getValue())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2Name.eq(param.getValue()));
        }
        if (StringUtils.hasLength(param.getKeyWords())) {
            predicate = ExpressionUtils.and(
                    predicate, ExpressionUtils.anyOf(
                            jpaQDo.deter2.like('%' + param.getKeyWords() + '%'),
                            jpaQDo.deter2Name.like('%' + param.getKeyWords() + '%')
                    ));
        }
        return predicate;
    }

    public List<InvWhDeter2RespVO> findDeter2sByWhId(Long whId){
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaSettingDO invWhAreaSettingDO = QInvWhAreaSettingDO.invWhAreaSettingDO;
        JPAQuery<InvWhDeter2RespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhDeter2RespVO.class,
                jpaQDo.deter2,
                jpaQDo.deter2Name,
                invWhAreaSettingDO.businessChoose,
                invWhAreaSettingDO.isZeroWh
                )
        ).from(jpaQDo)
                .innerJoin(invWhDO).on(jpaQDo.whId.eq(invWhDO.id))
                .leftJoin(invWhAreaSettingDO).on(jpaQDo.deter2Type.eq(invWhAreaSettingDO.deter2Type));
        Predicate predicate1 = jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull());
        Predicate predicate2 = jpaQDo.whId.eq(whId);
        jpaQuery.where(ExpressionUtils.allOf(predicate1,predicate2));
        return jpaQuery.fetch();
    }

    public List<InvWhAreaRespVO> findAllWhareas(){
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvDespatchConfigDO despatchConfigDO = QInvDespatchConfigDO.invDespatchConfigDO;
        JPAQuery<InvWhAreaRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                InvWhAreaRespVO.class,
                jpaQDo.id,
                jpaQDo.deter2Name,
                jpaQDo.deter2,
                jpaQDo.deter2Type,
                invWhDO.id.as("whId"),
                invWhDO.whCode,
                invWhDO.whName,
                invWhDO.ouId,
                invWhDO.ouCode,
                despatchConfigDO.id.as("desId"),
                despatchConfigDO.desCode,
                despatchConfigDO.desName
                )
        ).from(jpaQDo)
                .innerJoin(invWhDO).on(jpaQDo.whId.eq(invWhDO.id))
                .leftJoin(despatchConfigDO).on(invWhDO.desId.eq(despatchConfigDO.id));
        Predicate predicate1 = jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull());
        Predicate predicate2 = invWhDO.deleteFlag.eq(0).or(invWhDO.deleteFlag.isNull());
        jpaQuery.where(ExpressionUtils.allOf(predicate1,predicate2));
        return jpaQuery.fetch();
    }

    public List<InvWhAreaRespVO> findByDeter2s(List<String> deter2s) {
        val jpaQDo = QInvWhAreaDO.invWhAreaDO;
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhAreaRespVO.class,
                jpaQDo.id,
                jpaQDo.addrNo,
                jpaQDo.deter2Type,
                jpaQDo.deter2Name,
                jpaQDo.whId,
                jpaQDo.whArea,
                jpaQDo.deter2,
                jpaQDo.deter2Name,
                jpaQDo.deter2Type,
                jpaQDo.tenantId
        )).from(jpaQDo);
        Predicate predicate1 = jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull());
        Predicate predicate2 = jpaQDo.deter2.in(deter2s);
        jpaQuery.where(ExpressionUtils.allOf(predicate1,predicate2));
        return jpaQuery.fetch();
    }


}
