package com.elitesland.yst.production.inv.infr.repo.invwh;

import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeliveryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeliveryRespVO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDeliveryDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.List;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-05-28 14:00:14
 */
@Component
@AllArgsConstructor
public class InvWhDeliveryProc implements JpaQueryProcInterface {

    private final JPAQueryFactory jpaQueryFactory;
    
    private final QInvWhDeliveryDO invWhDelivery = QInvWhDeliveryDO.invWhDeliveryDO;

    /**
     * 查询字段
     */
    public List<InvWhDeliveryRespVO> select(InvWhDeliveryParamVO param) {
        Predicate predicate = invWhDelivery.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhDeliveryRespVO.class,
                invWhDelivery.id,
                invWhDelivery.ouId,
                invWhDelivery.buId,
                invWhDelivery.allArea,
                invWhDelivery.pCode.as("pcode"),
                invWhDelivery.pName.as("pname"),
                invWhDelivery.cCode.as("ccode"),
                invWhDelivery.cName.as("cname"),
                invWhDelivery.aCode.as("acode"),
                invWhDelivery.aName.as("aname"),
                invWhDelivery.sCode.as("scode"),
                invWhDelivery.sName.as("sname"),
                invWhDelivery.whId,
                invWhDelivery.tenantId,
                invWhDelivery.remark,
                invWhDelivery.createUserId,
                invWhDelivery.createTime,
                invWhDelivery.modifyUserId,
                invWhDelivery.modifyTime,
                invWhDelivery.deleteFlag,
                invWhDelivery.auditDataVersion
        )).from(invWhDelivery);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate, invWhDelivery.deleteFlag.eq(0).or(invWhDelivery.deleteFlag.isNull()));
        return jpaQuery.fetch();
    }

    public PagingVO<InvWhDeliveryRespVO> selectDeliveryPagingResult(InvWhDeliveryParamVO param) {
        Predicate predicate = invWhDelivery.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhDeliveryRespVO.class,
                invWhDelivery.id,
                invWhDelivery.ouId,
                invWhDelivery.buId,
                invWhDelivery.allArea,
                invWhDelivery.pCode,
                invWhDelivery.pName,
                invWhDelivery.cCode,
                invWhDelivery.cName,
                invWhDelivery.aCode,
                invWhDelivery.aName,
                invWhDelivery.sCode,
                invWhDelivery.sName,
                invWhDelivery.whId,
                invWhDelivery.tenantId,
                invWhDelivery.remark,
                invWhDelivery.createUserId,
                invWhDelivery.createTime,
                invWhDelivery.modifyUserId,
                invWhDelivery.modifyTime,
                invWhDelivery.deleteFlag,
                invWhDelivery.auditDataVersion
        )).from(invWhDelivery);
        if (param != null) {
            jpaQuery.where(where(param));
            param.fillOrders(jpaQuery, invWhDelivery);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(predicate, invWhDelivery.deleteFlag.eq(0).or(invWhDelivery.deleteFlag.isNull()));

        return PagingVO.<InvWhDeliveryRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }


    /**
     * 查询字段
     */
    public JPAQuery<InvWhDeliveryRespVO> findInByParam(InvWhDeliveryParamVO param) {
        Predicate predicate = invWhDelivery.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhDeliveryRespVO.class,
                invWhDelivery.id,
                invWhDelivery.ouId,
                invWhDelivery.buId,
                invWhDelivery.allArea,
                invWhDelivery.pCode,
                invWhDelivery.pName,
                invWhDelivery.cCode,
                invWhDelivery.cName,
                invWhDelivery.aCode,
                invWhDelivery.aName,
                invWhDelivery.sCode,
                invWhDelivery.sName,
                invWhDelivery.whId,
                invWhDelivery.tenantId,
                invWhDelivery.remark,
                invWhDelivery.createUserId,
                invWhDelivery.createTime,
                invWhDelivery.modifyUserId,
                invWhDelivery.modifyTime,
                invWhDelivery.deleteFlag,
                invWhDelivery.auditDataVersion
        )).from(invWhDelivery);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate, invWhDelivery.deleteFlag.eq(0).or(invWhDelivery.deleteFlag.isNull()));
        return jpaQuery;
    }


    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(InvWhDeliveryParamVO param) {
        Predicate predicate = invWhDelivery.isNotNull().or(invWhDelivery.isNull());

        if (!StringUtils.isEmpty(param.getOuId()) && ! param.getOuId().toString().equals("")) {
            predicate = ExpressionUtils.and(predicate, invWhDelivery.ouId.eq(param.getOuId()));
        }

        if (!StringUtils.isEmpty(param.getWhId()) && !param.getWhId().toString().equals("")) {
            predicate = ExpressionUtils.and(predicate, invWhDelivery.whId.eq(param.getWhId()));
        }
        return predicate;
    }

    public List<InvWhDeliveryRespVO> findWhDeliveryListByWhIds(List<Long> ids){
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhDeliveryRespVO.class,
                invWhDelivery.id,
                invWhDelivery.allArea,
                invWhDelivery.pCode.as("pcode"),
                invWhDelivery.pName.as("pname"),
                invWhDelivery.cCode.as("ccode"),
                invWhDelivery.cName.as("cname"),
                invWhDelivery.aCode.as("acode"),
                invWhDelivery.aName.as("aname"),
                invWhDelivery.sCode.as("scode"),
                invWhDelivery.sName.as("sname"),
                invWhDelivery.whId
        )).from(invWhDelivery);

        return jpaQuery.where(invWhDelivery.whId.in(ids)).fetch();
    }

   
}
