package com.elitesland.yst.production.inv.infr.repo.lot;

import com.elitesland.yst.production.inv.domain.entity.lot.InvLotDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import javax.transaction.Transactional;
import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 批次主档
 * </p>
 *
 * @author ssy
 * @since 2020-07-30 15:08:00
 */
@Repository
public interface InvLotRepo extends JpaRepository<InvLotDO, Long>, QuerydslPredicateExecutor<InvLotDO> {

    List<InvLotDO> findAllByItemIdAndLotNo(Long itmId, String lotNo);


    @Transactional
    @Modifying
    @Query("update InvLotDO set sinQty = ?3, sinStatus = ?4, sinNo = ?5 where itemId=?2 and lotNo=?1 ")
    void addSinQty(String lotNo, Long itemId, Double sinQty, String sinStatus, String sinNo);

    Optional<List<InvLotDO>> findByLotNo(String lotNo);

    @Query(value = "select * from inv_lot  where delete_flag = 0 and concat(item_id,IFNULL(vari_id,''),lot_no,ou_id) in (?1) ", nativeQuery = true)
    List<InvLotDO> findByConcatKey(List<String> concatKeys);

    @Query(value = "select lot_no from inv_lot  where delete_flag = 0 and menu_lot_no = ?1 ", nativeQuery = true)
    List<String> findByMenuLotNo(String menuLotNo);
}
