package com.elitesland.yst.production.inv.infr.repo.scene;

import com.elitesland.yst.production.inv.domain.entity.scene.InvSceneConfigDtlDO;
import com.elitesland.yst.production.inv.domain.entity.scene.QInvSceneConfigDtlDO;
import com.elitesland.yst.production.inv.infr.repo.JpaQueryProcInterface;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Tom.su
 * @program yst-inv
 * @description
 * @date 2022/04/20 17:21
 */
@Slf4j
@Component
@AllArgsConstructor
public class InvSceneConfigDtlRepoProc implements JpaQueryProcInterface {

    private final JPAQueryFactory jpaQueryFactory;

    public void updateDynamically(List<InvSceneConfigDtlDO> invSceneConfigDtlDOS) {
        val jpaQDO = QInvSceneConfigDtlDO.invSceneConfigDtlDO;
        for (InvSceneConfigDtlDO param : invSceneConfigDtlDOS) {
            JPAUpdateClause updateClause = jpaQueryFactory.update(jpaQDO);
            if (StringUtils.isNotBlank(param.getDeter2())) {
                updateClause.set(jpaQDO.deter2, param.getDeter2());
            }
            if (StringUtils.isNotBlank(param.getIoCode())) {
                updateClause.set(jpaQDO.ioCode, param.getIoCode());
            }
            if (StringUtils.isNotBlank(param.getIoType())) {
                updateClause.set(jpaQDO.ioType, param.getIoType());
            }
            if (StringUtils.isNotBlank(param.getOptDesc())) {
                updateClause.set(jpaQDO.optDesc, param.getOptDesc());
            }
            if (StringUtils.isNotBlank(param.getIsRelDocReq())) {
                updateClause.set(jpaQDO.isRelDocReq, param.getIsRelDocReq());
            }
            if (StringUtils.isNotBlank(param.getIsUseRelDoc())) {
                updateClause.set(jpaQDO.isUseRelDoc, param.getIsUseRelDoc());
            }
            if (StringUtils.isNotBlank(param.getRelDocType())) {
                updateClause.set(jpaQDO.relDocType, param.getRelDocType());
            }
            if (param.getOptSeq() != null) {
                updateClause.set(jpaQDO.optSeq, param.getOptSeq());
            }
            updateClause.set(jpaQDO.modifyTime, LocalDateTime.now());
            updateClause.where(jpaQDO.id.eq(param.getId())).execute();
        }
    }
}