package com.elitesland.yst.production.inv.job.service.impl;


import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkSsParamVO;
import com.elitesland.yst.production.inv.application.service.InvStkSsService;
import com.elitesland.yst.production.inv.job.service.InvStkSsJobService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import com.alibaba.fastjson.JSONObject;
import org.springframework.transaction.annotation.Transactional;

import java.util.Objects;


@Slf4j
@Service
@RequiredArgsConstructor
public class InvStkSsJobServiceImpl implements InvStkSsJobService {

    private final InvStkSsService invStkSsService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void storageInfoSync(String param, TenantDataIsolateProvider tenantDataIsolateProvider) {
        InvStkSsParamVO invStkSsParamVO = new InvStkSsParamVO();
        if (!StringUtils.isEmpty(param)) {
            JSONObject jSONObject = JSONObject.parseObject(param);
            InvStkSsParamVO purPriceParamVo2 = JSONObject.toJavaObject(jSONObject, InvStkSsParamVO.class);
            if (Objects.nonNull(purPriceParamVo2)){
                BeanUtils.copyProperties(purPriceParamVo2,invStkSsParamVO);
            }
        }
        invStkSsService.createStkSs(invStkSsParamVO.getSsTime(),tenantDataIsolateProvider);
    }
}
