package com.elitesland.yst.production.inv.provider;

import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.inv.Application;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvCommonConvert;
import com.elitesland.yst.production.inv.dto.invstk.InvStkCommonResultRpcDto;
import com.elitesland.yst.production.inv.dto.invstk.InvStkQtyResultRpcDTO;
import com.elitesland.yst.production.inv.dto.invstk.param.InvStkCommonOperateRpcParam;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkQtyResultDTO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author sushiqi
 * @date 2022/04/24
 * <p>
 * 库存操作通用Dubbo接口
 * </p>
 */
@Service
@AllArgsConstructor

@Slf4j
@RestController
@RequestMapping(Application.URI_PREFIX + InvStkCommonProvider.PATH)
public class InvStkCommonProviderImpl implements InvStkCommonProvider {

    private final InvStkOptBizService invStkOptBizService;

    /**
     * 库存操作公共Dubbo接口
     *
     * @param param
     * @return InvStkCommonResultRpcDto
     * @date 2022/04/24
     * @since 0.2.4-SNAPSHOT
     */
    @Override
    public ApiResult<InvStkCommonResultRpcDto> invStkCommonOperate(InvStkCommonOperateRpcParam param) {
        long begin = System.currentTimeMillis();
        log.info("库存操作通用Dubbo接口,入参：{}", JSON.toJSONString(param));
        try{
            InvStkCommonOperateDTO stkCommonOperateDTO = InvCommonConvert.INSTANCE.invStkCommonOperateRpcParam2DTO(param);
            List<InvStkCommonOperateBodyDTO> sourceBodyList = InvCommonConvert.INSTANCE.invStkCommonOperateRpcBodyParam2DTO(param.getSourceBodyList());
            List<InvStkCommonOperateBodyDTO> targetBodyList = InvCommonConvert.INSTANCE.invStkCommonOperateRpcBodyParam2DTO(param.getTargetBodyList());
            stkCommonOperateDTO.setSourceBodyList(sourceBodyList);
            stkCommonOperateDTO.setTargetBodyList(targetBodyList);
            List<InvStkQtyResultDTO> resultDTOList = invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
            InvStkCommonResultRpcDto invStkCommonResultRpcDto = new InvStkCommonResultRpcDto();
            invStkCommonResultRpcDto.setIsSuccessful(true);
            invStkCommonResultRpcDto.setMessage("操作成功");
            List<InvStkQtyResultRpcDTO> resultRpcDTOS = resultDTOList.stream().map(InvCommonConvert.INSTANCE::stkQtyResultDTOToStkQtyResultRpcDTO).collect(Collectors.toList());
            invStkCommonResultRpcDto.setResult(resultRpcDTOS);
            log.info("库存操作通用Dubbo接口,返回结果集：{}", JSON.toJSONString(invStkCommonResultRpcDto));
            return ApiResult.ok(invStkCommonResultRpcDto);
        }catch (BusinessException e){
            log.error("库存操作通用Dubbo接口,业务异常，流水号：" + param.getRequestId() + ",来源系统：" + param.getSource() + ",原因：", e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }catch (Exception e){
            log.error("库存操作通用Dubbo接口,系统异常，流水号：" + param.getRequestId() + ",来源系统：" + param.getSource() + ",原因：", e);
            throw  new BusinessException(ApiCode.SYSTEM_EXCEPTION, e.getMessage());
        }finally {
            log.info("库存操作通用Dubbo接口,处理耗时：[{}ms]", System.currentTimeMillis() - begin);
        }
    }
}
