package com.elitesland.yst.production.inv.provider;


import com.elitesland.yst.production.inv.Application;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.*;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.service.InvLotService;
import com.elitesland.yst.production.inv.application.service.InvStkService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaSettingService;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvStkConvert;
import com.elitesland.yst.production.inv.domain.service.InvStkDomainService;
import com.elitesland.yst.production.inv.dto.invstk.*;
import com.elitesland.yst.production.inv.utils.InvPTypeEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.utils.ValidationUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemUomConvRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.item.param.ItmItemUomConvRpcDtoParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明: 库存余额查询
 * </p>
 *
 * @author jeesie.jiang
 * @since 2022-05-07 14:00:10
 */
@Service
@RequiredArgsConstructor

@Slf4j
@RestController
@RequestMapping(Application.URI_PREFIX + InvStkProvider.PATH)
public class InvStkProviderImpl implements InvStkProvider {

    @Autowired
    private InvStkDomainService invStkDomainService;

    @Autowired
    private ItmOutService itmOutService;

    @Autowired
    private OrgOutService orgOutService;

    @Autowired
    private InvWhService invWhService;

    @Autowired
    private InvWhAreaSettingService invWhAreaSettingService;

    @Autowired
    private InvLotService invLotService;

    @Autowired
    private InvStkService invStkService;


    @Override
    public List<InvStkRpcDTO> findInvStkRpcDtoByParam(InvStkAllRpcDtoParam invStkAllRpcDtoParam) {
        log.info("条件查询库存方法开始：时间：{},参数:{}", LocalDateTime.now(),invStkAllRpcDtoParam);
        if(null != invStkAllRpcDtoParam.getMenuLotNo() && ! "".equals(invStkAllRpcDtoParam.getMenuLotNo())){
            List<String> lotNos = invLotService.findLotNoByManuLot(invStkAllRpcDtoParam.getMenuLotNo());
            invStkAllRpcDtoParam.setLotNos(lotNos);
        }
        List<InvStkRpcDTO> stkRpcDTOList = invStkDomainService.findStkAllRpcDTOByParam(invStkAllRpcDtoParam);
        //单位统一转换
        List<InvStkRpcDTO> stkRpcDTOS = this.stkUomBatchConvertHandle(stkRpcDTOList, invStkAllRpcDtoParam.getInvStkItemUomParams());
        translate(stkRpcDTOS);
        return stkRpcDTOList;

    }

    @Override
    public ApiResult<InvStkRpcDTO> getInvStk(InvStkRpcDtoParam param) {
        log.info("查询库存方法开始：时间：{},参数:{}", LocalDateTime.now(),param);
        validParam(param);
        List<InvStkRpcDTO> invStkRespVOs = invStkDomainService.getInvStkRpcDTOByParam(param);
        if(!CollectionUtils.isEmpty(invStkRespVOs)){
            translate(invStkRespVOs);
            InvStkRpcDTO invStkDTO = invStkRespVOs.get(0);
            if(!invStkDTO.getUom().equals(param.getToUom())) {
                //单位统一转换
                InvStkRpcDTO invStkRpcDTO = stkUomConvertHandle(invStkRespVOs, param.getToUom()).get(0);
                return ApiResult.ok(invStkRpcDTO);
            }else {
                return ApiResult.ok(invStkDTO);
            }

        }
        return ApiResult.ok(null);
    }

    @Override
    public List<ItmInvStkItemRpcDTO> getItemInvStk(InvStkItemRpcDtoParam param) {
        InvStkItemQueryParam queryParam = InvStkConvert.INSTANCE.stkItemRpcDtoParamToParam(param);
        List<ItmInvStkItemRespVO> stkItemRespVOS = invStkService.getInvStkItemByParam(queryParam);
        if(!CollectionUtils.isEmpty(stkItemRespVOS)){
            return stkItemRespVOS.stream().map(InvStkConvert.INSTANCE::stkItemVoToDto).collect(Collectors.toList());
        }else{
            return new ArrayList<ItmInvStkItemRpcDTO>();
        }
    }

    @Override
    public PagingVO<InvStkGroupRpcDTO> searchPaging(InvStkAllRpcDtoParam param) {
        InvStkQueryGroupParamVO groupParamVO = InvStkConvert.INSTANCE.allRpcParamToParam(param);
        PagingVO<InvStkGroupRespVO> pagingVO = invStkService.searchD(groupParamVO);
        List<InvStkGroupRpcDTO> ret = pagingVO.getRecords().stream().map(InvStkConvert.INSTANCE::stkRespVoToGroupRpcDto).collect(Collectors.toList());
        return PagingVO.<InvStkGroupRpcDTO>builder()
                .total(pagingVO.getTotal())
                .records(ret)
                .build();

    }

    @Override
    public PagingVO<InvStkDRpcDTO> searchLotPaging(InvStkDRpcDtoParam param) {
        InvStkDQueryParamVO queryParam = InvStkConvert.INSTANCE.rpcDtoParamToParam(param);
        PagingVO<InvStkDRespVO> pagingVO = invStkService.searchLot(queryParam);
        List<InvStkDRpcDTO> result = pagingVO.getRecords().stream().map(InvStkConvert.INSTANCE::respVoToRpcDto).collect(Collectors.toList());
        return PagingVO.<InvStkDRpcDTO>builder()
                .total(pagingVO.getTotal())
                .records(result)
                .build();
    }



    private List<InvStkRpcDTO> stkUomBatchConvertHandle(List<InvStkRpcDTO> stkRpcDTOList, List<InvStkItemUomRpcDtoParam> stkItemUomParams) {
        if(CollectionUtils.isEmpty(stkItemUomParams)){
            return stkRpcDTOList;
        }
        List<Long> itemIds = stkItemUomParams.stream().map(InvStkItemUomRpcDtoParam::getItemId).distinct().collect(Collectors.toList());
        //查询商品主计量单位
        List<ItmItemUomConvRpcDTO> uomConvRpcDTOS = this.getUomConvRpcDTOS(itemIds);
        //单位转换
        stkRpcDTOList.stream().forEach(v -> {
            stkItemUomParams.stream().filter(i -> i.getItemId().equals(v.getItemId())
                    && !i.getToUom().equals(v.getUom()))
                    .findAny().ifPresent(invStkItemUomParam -> {
                InvUomQueryParamVO queryParamVO = new InvUomQueryParamVO();
                queryParamVO.setFromUom(v.getUom());
                queryParamVO.setToUom(invStkItemUomParam.getToUom());
                queryParamVO.setItemId(v.getItemId());
                queryParamVO.setItemCode(v.getItemCode());
                BigDecimal uomRatio = itmOutService.getUomRatio(uomConvRpcDTOS, queryParamVO);
                if (uomRatio.compareTo(BigDecimal.ZERO) > 0) {
                    v.setAvalQty(v.getAvalQty().multiply(uomRatio));
                } else if (uomRatio.compareTo(BigDecimal.ZERO) < 0) {
                    v.setAvalQty(this.calculateQty2(uomRatio, v.getAvalQty()));
                }
                v.setUom(invStkItemUomParam.getToUom());
                v.setUomRatio(uomRatio);
            });
        });
        return stkRpcDTOList;

    }

    private List<InvStkRpcDTO> stkUomConvertHandle(List<InvStkRpcDTO> stkRpcDTOList,String toUom){
        List<Long> itemIds = stkRpcDTOList.stream().map(InvStkRpcDTO::getItemId).distinct().collect(Collectors.toList());
        //查询商品主计量单位
        List<ItmItemUomConvRpcDTO> uomConvRpcDTOS = this.getUomConvRpcDTOS(itemIds);
        //单位转换
        stkRpcDTOList.stream().forEach(v -> {
            if(! v.getUom().equals(toUom)) {
                InvUomQueryParamVO queryParamVO = new InvUomQueryParamVO();
                queryParamVO.setFromUom(v.getUom());
                queryParamVO.setToUom(toUom);
                queryParamVO.setItemId(v.getItemId());
                queryParamVO.setItemCode(v.getItemCode());
                BigDecimal uomRatio = itmOutService.getUomRatio(uomConvRpcDTOS, queryParamVO);
                if(uomRatio.compareTo(BigDecimal.ZERO) > 0) {
                    v.setAvalQty(v.getAvalQty().multiply(uomRatio));
                } else if(uomRatio.compareTo(BigDecimal.ZERO) < 0){
                    v.setAvalQty(this.calculateQty2(uomRatio,v.getAvalQty()));
                }
                v.setUom(toUom);
            }
        } );
        return stkRpcDTOList;

    }


    private BigDecimal calculateQty2(BigDecimal uomRatio, BigDecimal qty) {
        return qty.divide(uomRatio.negate(), 2, RoundingMode.HALF_UP);
    }


    private List<ItmItemUomConvRpcDTO> getUomConvRpcDTOS(List<Long> itemIds) {
        ItmItemUomConvRpcDtoParam param = new ItmItemUomConvRpcDtoParam();
        param.setItemIds(itemIds);
        List<ItmItemUomConvRpcDTO> uomConvRpcDTOS = itmOutService.findItemUomConvDtoByParam(param);
        return uomConvRpcDTOS;
    }


    private void validParam(InvStkRpcDtoParam param) {
        // 必填参数校验
        ValidationUtil.ValidResult validResult = ValidationUtil.validate(param);
        if (validResult.isError()) {
            throw new BusinessException("参数错误，商品、仓库、功能区、转换单位不能为空！");
        }
        if (param.getPType() != null && param.getPCode() == null) {
            throw new BusinessException("参数错误，库存合作伙伴编码不能为空！");
        }
        if (param.getPCode() != null && param.getPType() == null) {
            throw new BusinessException("参数错误，库存合作伙伴类型不能为空！");
        }

    }

    /**
     * searchD方法中应对前端参数为空情况
     * @param stkResults
     */
    public void translate(List<InvStkRpcDTO> stkResults){
        //调用接口查询库存合作伙伴等字段
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        List<Long> itemIds = stkResults.stream().map(InvStkRpcDTO::getItemId).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(itemIds)){
            itemIds = null;
        }
        itmItemPartParam.setItemIds(itemIds);
        val orgOuResults =  orgOutService.findOuByIds(stkResults.stream().map(InvStkRpcDTO::getOuId).collect(Collectors.toList()));
        val itmItemResults=itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        List<String> pcodes = stkResults.stream().filter(s -> UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(s.getPType())).map(InvStkRpcDTO::getPCode)
                .collect(Collectors.toList());
        List<OrgRespVO> empList = orgOutService.findcodeAndNameList(InvPTypeEnum.INV_PARTNER_TYPE_EMP, pcodes);
        //填入数据
        stkResults.stream().forEach(i -> {
            if(!CollectionUtils.isEmpty(itmItemResults)) {
                itmItemResults.stream().filter(v -> v.getId().equals(i.getItemId()))
                        .findAny().ifPresent(m -> {
                    i.setItemCode(m.getItemCode());

                });
            }
            if(!CollectionUtils.isEmpty(orgOuResults)) {
                orgOuResults.stream().filter(o -> o.getId().equals(i.getOuId()))
                        .findAny().ifPresent(m -> {
                    i.setOuCode(m.getOuCode());
                    i.setOuName(m.getOuName());
                });
            }
            if(UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(i.getPType()) && !CollectionUtils.isEmpty(empList)){
                empList.stream().filter(m -> m.getCode().equals(i.getPCode()) ).findAny().ifPresent(m ->{
                    i.setPName(m.getName());
                });
            }

        });

    }


}
