package com.elitesland.yst.production.inv.provider;


import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.inv.Application;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.*;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhAreaDO;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.dto.invTrn.InvTrnResultRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaParamRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaSaveDTO;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import lombok.AllArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-07-16 14:07:11
 */
@Service("invWhAreaProvide")
@AllArgsConstructor
@Slf4j
@RestController
@RequestMapping(Application.URI_PREFIX + InvWhAreaProvider.PATH)
public class InvWhAreaProviderImpl implements InvWhAreaProvider {

    private final InvWhAreaDomainService invWhAreaDomainService;

    private final OrgOutService orgOutService;

    private final SystemService systemService;

    private final InvWhAreaService invWhAreaService;


    @Override
    public List<InvWhAreaRpcDTO> findByWhId(Long whId) {
        InvWhAreaRpcDtoParam paramRpcDTO = new InvWhAreaRpcDtoParam();
        paramRpcDTO.setWhId(whId);
        List<InvWhAreaRpcDTO> whAreaRpcDTOS = invWhAreaDomainService.selectWhAreaRpcDTOByParam(paramRpcDTO);
        return whAreaRpcDTOS;
    }

    @Override
    public InvWhAreaRpcDTO findByAreaId(Long id) {
        InvWhAreaRpcDTO invWhAreaRpcDTO = new InvWhAreaRpcDTO();
        Optional<InvWhAreaDO> oneById = invWhAreaDomainService.findOneById(id);
        if(oneById.isPresent()){
            InvWhAreaDO invWhAreaDO = oneById.get();
            BeanUtils.copyProperties(invWhAreaDO,invWhAreaRpcDTO);
            return invWhAreaRpcDTO;
        }else{
            return null;
        }
    }


    @Override
    @SysCodeProc
    public List<InvWhAreaRpcDTO> findByWhIds(List<Long> whIds) {
        InvWhAreaRpcDtoParam paramRpcDTO = new InvWhAreaRpcDtoParam();
        paramRpcDTO.setWhIds(whIds);
        List<InvWhAreaRpcDTO> whAreaRpcDTOS = invWhAreaDomainService.selectWhAreaRpcDTOByParam(paramRpcDTO);
        Map<String, String> pTypeMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_EMP.getModel(), UdcEnum.INV_PARTNER_TYPE_EMP.getCode());
        for (InvWhAreaRpcDTO whAreaRpcDTO : whAreaRpcDTOS) {
            if (!StringUtils.isEmpty(whAreaRpcDTO.getPType()) && !StringUtils.isEmpty(whAreaRpcDTO.getPCode())) {
                InvParentParamVO paramVO = new InvParentParamVO();
                paramVO.setType(whAreaRpcDTO.getPType());
                paramVO.setCode(whAreaRpcDTO.getPCode());
                List<OrgRespVO> vos = orgOutService.findcodeAndName(paramVO);
                if (!CollectionUtils.isEmpty(vos)) {
                    vos.stream().filter(m -> m.getCode().equals(whAreaRpcDTO.getPCode())).findFirst().ifPresent(n -> {
                        whAreaRpcDTO.setPName(n.getName());
                    });
                }
                if (!MapUtils.isEmpty(pTypeMap)) {
                    whAreaRpcDTO.setPTypeName(pTypeMap.get(whAreaRpcDTO.getPType()));
                }
            }
        }
        return whAreaRpcDTOS;
    }

    @Override
    public List<Long> createBatch(List<InvWhAreaSaveDTO> list) {
        log.info("保存功能库区入参：{}", JSON.toJSONString(list));

        if(CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }
        List<InvWhAreaSaveVO> collect = list.stream().map(t -> {
            return BeanUtil.copyProperties(t, InvWhAreaSaveVO.class);
        }).collect(Collectors.toList());
        List<Long> batch = invWhAreaService.createBatch(collect);
        log.info("保存功能库区返回参数：{}", JSON.toJSONString(list));
        return batch;
    }

    @Override
    public ApiResult deleteByWhId(Long whId) {
        log.info("deleteByWhId删除功能区：{}", JSON.toJSONString(whId));

        if(whId != null ){
            //根据仓库ID删除功能库区
            invWhAreaDomainService.deleteByWhId(whId);
            return ApiResult.ok();
        }
        return ApiResult.fail();
    }

    @Override
    public ApiResult deleteByAreaId(List<Long> ids) {
        log.info("deleteByAreaId删除功能区：{}", JSON.toJSONString(ids));

        if(!CollectionUtils.isEmpty(ids)){
            //根据仓库ID删除功能库区
            invWhAreaDomainService.deleteBatch(ids);
            return ApiResult.ok();
        }
        return ApiResult.fail();
    }

    @Override
    public List<InvWhAreaRpcDTO> findDeter2List(InvWhAreaParamRpcDTO param) {
        log.info("findDeter2List功能区开始：{}", JSON.toJSONString(param));
        if(CollectionUtils.isEmpty(param.getDeter2s()) || CollectionUtils.isEmpty(param.getWhIds())){
            throw new BusinessException("参数校验不通过，仓库、功能区 不能为空");
        }
        InvWhAreaRpcDtoParam invWhAreaParamVO = new InvWhAreaRpcDtoParam();
        invWhAreaParamVO.setDeter2s(param.getDeter2s());
        invWhAreaParamVO.setWhIds(param.getWhIds());
        invWhAreaParamVO.setDeter2Types(param.getDeter2Types());
        List<InvWhAreaRpcDTO> invWhAreaRespVOS = invWhAreaDomainService.selectWhAreaRpcDTOByParam(invWhAreaParamVO);
        return invWhAreaRespVOS;
    }

}
