package com.elitesland.yst.production.inv.provider;

import com.elitesland.yst.production.inv.Application;
import com.elitesland.yst.production.inv.domain.convert.InvWhAreaSettingConvert;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaSettingDomainService;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaSettingRpcDTO;
import com.elitesland.yst.production.inv.dto.invwhAreaSetting.InvWhAreaSettingParamRpcDTO;
import com.elitesland.yst.production.inv.infr.dto.InvWhAreaSettingDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;


@Service
@RequiredArgsConstructor

@Slf4j
@RestController
@RequestMapping(Application.URI_PREFIX + InvWhAreaSettingProvider.PATH)
public class InvWhAreaSettingProviderImpl implements InvWhAreaSettingProvider {

    @Autowired
    private InvWhAreaSettingDomainService invWhAreaSettingDomainService;

    @Override
    @Deprecated
    public List<InvWhAreaSettingRpcDTO> findDeter2List(List<String> deter2s) {
        List<InvWhAreaSettingDTO> whAreaSettingDTOS = invWhAreaSettingDomainService.findByDeter2Batch(deter2s);
        List<InvWhAreaSettingRpcDTO> whAreaSettingRpcDTOS = whAreaSettingDTOS.stream().map(InvWhAreaSettingConvert.INSTANCE::dtoToRpcDto).collect(Collectors.toList());
        return whAreaSettingRpcDTOS;
    }

    @Override
    public List<InvWhAreaSettingRpcDTO> findWhAreaSettingByParam(InvWhAreaSettingParamRpcDTO whAreaSettingParamRpcDTO) {
        return invWhAreaSettingDomainService.findWhAreaSettingRpcDTO(whAreaSettingParamRpcDTO);
    }


}
