package com.elitesland.yst.production.inv.application.facade.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * INV_AJ
 * InvAjDVO
 * 库存调整
 *
 * @author lich.chen
 * @date 2020/08/3
 */
@Data
@ExcelIgnoreUnannotated
@ApiModel("库存调整")
public class InvAjAndInvAjDDownloadRespVO implements Serializable {
    private static final long serialVersionUID = 1096288064972391708L;

    @ExcelProperty("调整单号")
    String docNo;

    @ExcelProperty("调整类型")
    String docTypeName;

    @ExcelProperty("调整单状态")
    String docStatusName;
    @ExcelProperty("公司名称")
    String ouName;
    @ExcelProperty("申请日期")
    LocalDateTime applyDate;
    @ExcelProperty("交易日期")
    LocalDateTime ioDate;
    @ExcelProperty("仓库编码")
    String whCode;
    @ExcelProperty("仓库名称")
    String whName;

    @ExcelProperty("调整原因")
    String reasonCodeName;

    @ExcelProperty("功能库区")
    String deter2Name;

    @ExcelProperty("商品编号")
    String itemCode;
    @ExcelProperty("商品名称")
    String itemName;
    @ExcelProperty("调整数量")
    BigDecimal qty;

    @ExcelProperty("调整金额")
    BigDecimal ajAmt;

    @ExcelProperty("批次号")
    String lotNo;

    @ColumnWidth(21)
    @ExcelProperty("库存合作伙伴类型")
    String partnerTypeName;

    @ColumnWidth(21)
    @ExcelProperty("库存合作伙伴名称")
    String partnerName;

    @ColumnWidth(21)
    @ExcelProperty("库存合作伙伴编号")
    String partnerCode;
    @ExcelProperty("备注")
    String remark;

}
